@extends('layouts.admin')

@section('title', ' รายละเอียดใบกำกับกล่องสินค้า')

@section('content')


  <form action="{{ route("admin.shippingmark.store") }}" method="POST" enctype="multipart/form-data">
      @csrf


    <div class="card">
        <div class="card-header">
           รายละเอียดใบกำกับกล่องสินค้า
        </div>

        <div class="card-body">
            <div class="row">
              <div class="col-lg-3" >
                    PO: <input type="text" class="form-control" name="XVPONbr"value="{{ old('XVPONbr', isset($data['boxDB']) ? $data['boxDB']->XVPONbr : '') }}" readonly  required >
              </div>
              <div class="col-lg-3">
                   รหัสสาขา: <input type="text" class="form-control" name="XVStoreNbr" value="{{ old('XVStoreNbr', isset($data['boxDB']) ? $data['boxDB']->XVStoreNbr : '') }}" readonly  required>
              </div>
              <div class="col-lg-3">
                  บาร์โค้ดกำกับกล่อง: <input type="text" class="form-control" name="XVBoxCode" value="{{ old('XVBoxCode', isset($data['boxDB']) ? $data['boxDB']->XVBoxCode : '') }}" readonly  required>
              </div>
              {{-- <div class="col-lg-3" style="margin-top:20px">
                <a href=""><button type="submit" class="btn btn-primary" >บันทึก</button></a>
              </div> --}}

            </div>

            <div class="col" style="margin-top:40px">
              <div class="table-responsive " >
                  <table class="table table-bordered table-striped table-hover datatable" style="margin-top:40px">
                      <thead>
                      <tr>
                          <th>UPC</th>
                          <th>SKU</th>
                          <th>Description</th>
                          <th>Size</th>
                          <th>QTY</th>
                      </tr>
                      </thead>
                      <tbody>

                          @foreach($data['box'] as $key => $box)
                          <tr >
                                <td>
                                    {{ $box->XVUPCCode ?? '' }}
                                </td>
                                <td>
                                    {{ $box->XVSKUCode ?? '' }}
                                </td>
                                <td>
                                    {{ $box->XVDescription ?? '' }}
                                </td>
                                <td>
                                    {{ $box->XVSize ?? '' }}
                                </td>
                                <td>
                                    {{ $box->XISupQty ?? '' }}
                                </td>
                          </tr>
                      @endforeach

                      </tbody>

                  </table>

              </div>
          </div><!--col-->
      </div>
      <div class="card-footer">
        <div class="row">
            <div class="col">
              <a href="{{route('admin.shippingmark.index')}}" class="btn btn-danger active" role="button" aria-pressed="true">{{ trans('global.back') }}</a>
            </div>


        </div>
    </div>


      </div>




</form>


@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
<script>
  $(function () {


      $('.datatable:not(.ajaxTable)').DataTable({
          "pageLength": 25
      })
  })
</script>
@endsection
