@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | ทดสอบ')

@section('content')

<input type="text" style="margin-top:10px;width:509px " name="XVOrderBCode" id="XVOrderBCode" class="text-center" placeholder="แสกนบาร์โค้ด">

@endsection

@section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
@endsection

@section('scripts')
<script>
      $(function () {
        $('#XVOrderBCode').focus();
          $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

        const Toast = Swal.mixin({
        toast: true,
        position: 'bottom-end',
        showConfirmButton: false,
        timer: 1000,
        timerProgressBar: true,
        onOpen: (toast) => {
            toast.addEventListener('mouseenter', Swal.stopTimer)
            toast.addEventListener('mouseleave', Swal.resumeTimer)
        }
        })


        var count_scan = 0;
        $('#XVOrderBCode').keyup(function(e){
        if(e.keyCode == 13)
        {
            $this = $(this);
            if ($this.val().length != 18){

                Swal.fire({
                title: 'Oops....',
                text: "เลขบาร์โค้ดไม่ถูกต้องกรุณาตรวจสอบ!",
                icon: 'warning',
                confirmButtonColor: '#3085d6',
                confirmButtonText: 'OK'
                }).then((result) => {
                    if (result.value) {
                                        return false;
                    }
                })
            }else{

            console.log('{{url('')}}/admin/scanforbleachingjobsupdate')
                $.ajax({
                type:'POST',
                url:'{{url('')}}/admin/scanforbleachingjobsupdate',
                data:{barcode: $this.val(),location:6},
                dataType: 'JSON',
                success:function(data){
                    if(data.success =="0"){
                        Swal.fire({
                        title: 'Oops....',
                        text: "ไม่พบข้อมูลในระบบกรุณาตรวจสอบ !",
                        icon: 'warning',
                        confirmButtonColor: '#3085d6',
                        confirmButtonText: 'OK'
                        }).then((result) => {
                        if (result.value) {
                            $('#order_no').html("")
                            $('#size').html("")
                        }
                        })

                    }else{
                        Toast.fire({
                        icon: 'success',
                        title: 'Scan สำเร็จ'

                        })

                        count_scan++
                        $('#count_all').html(count_scan)
                        $('#order_no').html(data.order_no)
                        $('#size').html(data.size)
                        $this.val('')

                    }
                }
                });
            }





        }
    });


      })
</script>
@endsection
