@extends('layouts.admin')

@section('title', 'หน้าจอสถานที่เย็บรวมตัว | เพิ่ม')

@section('content')

  <form action="{{ route("admin.totalsewinglocatin.store") }}" method="POST" enctype="multipart/form-data">
      @csrf

    <div class="card">
        <div class="card-header">
            {{ trans('global.create') }}{{ trans('global.totalsewinglocatin') }}
        </div>

        <div class="card-body">

            <div class="form-group {{ $errors->has('XVTotalSewName') ? 'has-error' : '' }}">
                <label for="XVTotalSewName">{{ trans('global.TMtotalsew.fields.XVTotalSewName') }}*</label>
                <input type="text" id="XVTotalSewName" name="XVTotalSewName" class="form-control" maxlength="191" value="{{ old('XVTotalSewName', isset($totalsewinglocatin) ? $totalsewinglocatin->XVTotalSewName : '') }}">
                @if($errors->has('XVTotalSewName'))
                    <em class="invalid-feedback">
                       กรุณากรอกชื่อ
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.TMtotalsew.fields.XVTotalSewName_helper') }}
                </p>
            </div>

            <div class="form-group {{ $errors->has('XITotalSewTel') ? 'has-error' : '' }}">
                <label for="price">{{ trans('global.TMtotalsew.fields.XITotalSewTel') }}</label>
                <input type="text" id="XITotalSewTel" name="XITotalSewTel" class="form-control" maxlength="20" value="{{ old('XITotalSewTel', isset($totalsewinglocatin) ? $totalsewinglocatin->XITotalSewTel : '') }}" >
                @if($errors->has('XITotalSewTel'))
                    <em class="invalid-feedback">
                        {{ $errors->first('XITotalSewTel') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.TMtotalsew.fields.XITotalSewTel_helper') }}
                </p>
            </div>

            <div class="form-group {{ $errors->has('XVTotalSewAddress') ? 'has-error' : '' }}">
                <label for="XVTotalSewAddress">{{ trans('global.TMtotalsew.fields.XVTotalSewAddress') }}</label>
                <textarea id="XVTotalSewAddress" name="XVTotalSewAddress" class="form-control " maxlength="191">{{ old('XVTotalSewAddress', isset($totalsewinglocatin) ? $totalsewinglocatin->XVTotalSewAddress : '') }}</textarea>
                @if($errors->has('XVTotalSewAddress'))
                    <em class="invalid-feedback">
                        {{ $errors->first('XVTotalSewAddress') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.TMtotalsew.fields.XVTotalSewAddress_helper') }}
                </p>
            </div>

      </div>

      <div class="card-footer">
          <div class="row">
              <div class="col">
                <a href="{{route('admin.totalsewinglocatin.index')}}" class="btn btn-danger active" role="button" aria-pressed="true">{{ trans('global.back') }}</a>
              </div>

              <div class="col text-right">
                <input class="btn btn-success active" type="submit" value="{{ trans('global.save') }}">
              </div>
          </div>
      </div>

    </div>

</form>
@endsection
