@extends('layouts.admin')

@section('title', 'ใบสั่งพิมพ์ Barcode')

@section('content')
    <div class="card">
        <form action="{{ route("admin.order.update", [$order['XVOrderDocNo']]) }}" method="POST" id="frm" enctype="multipart/form-data">
         @csrf
        @method('PUT')
        <input type="hidden" name="XCStatus" id="XCStatus" value="">
        <div class="card-header text-right col">
            ใบสั่งพิมพ์ Barcode
        </div>
        <div class="card-body">
            <div class="form-row">
                <div class="form-group col-md-4">

                </div>
                <div class="form-group col-md-2">
                    <label for="text">เลขที่เอกสาร</label>
                    <input type="text" name="XVOrderDocNo" class="form-control text-right" id="" value="{{ old('XVOrderDocNo', isset($order) ? $order['XVOrderDocNo'] : 'Autoid') }}" readonly >
                </div>
                <div class="form-group col-md-2">
                    <label for="text">วันที่สร้าง Order</label>
                    <input type="text" name="XDOrderDocMDate" class="form-control" id="text" value="{{ old('XDOrderDocMDate', isset($order['order_hd']) ? $order['order_hd']->XDOrderDocMDate : '') }}" readonly>
                </div>
                <div class="form-group col-md-2">
                    <label for="text">วันที่อนุมัติ</label>
                    <input class="form-control end_date" type="text" placeholder="วัน/เดือน/ปี" data-date-format="dd/mm/yyyy" name="XDOrderDateApprove"
                       value="{{ old('XDOrderDateApprove', isset($order['order_hd']->XDOrderDateApprove) ? DATE_FORMAT(new DateTime($order['order_hd']->XDOrderDateApprove),'d/m/Y') : DATE_FORMAT(NOW(),'d/m/Y')) }}"
                       required="required" readonly>
                </div>
                <div class="form-group col-md-2">
                    <label for="text">item No:</label>
                    <input type="text" class="form-control"  name="XVOrderMItemNo" id="XVOrderMItemNo" value="{{ old('XVOrderMItemNo', isset($order['order_hd']) ? $order['order_hd']->XVOrderMItemNo : '') }}" readonly>
                </div>
            </div><!--end form row-->

            <div class="form-row">
                <div class="form-group col-md-2">
                    <label for="text">Season:</label>
                    <input required="required" class="col-sm-12 form-control font-size" type="text" name="XVOrderMSeasion" id="XVOrderMSeasion" value="{{ old('XVOrderMSeasion', isset($order['order_hd']) ? $order['order_hd']->XVOrderMSeasion : '') }}"   placeholder="Season" style="font-size: 16px;" readonly>
                </div>
                <div class="form-group col-md-2">
                    <label for="text">ลูกค้า</label>
                   <select id="XIGuestCode" name="XIGuestCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;" readonly>
                        @foreach ($order['customer'] as $customer)
                          <option value="{{ $customer->XIGuestCode }}" {{ old('XIGuestCode', (isset($order['order_hd']) && $order['order_hd']->XIGuestCode == $customer->XIGuestCode) ? 'selected' : '') }}>{{ $customer->XVGuestName }} </option>
                        @endforeach
                      </select>
                </div>
                <div class="form-group col-md-8">
                    <label for="text">รายละเอียด</label>
                    <input required="required" class="col-sm-12 form-control font-size" type="text" name="XVOrderDetail" id="XVOrderDetail" value="{{ old('XVOrderDetail', isset($order['order_hd']) ? $order['order_hd']->XVOrderDetail : '') }}"   placeholder="Season" style="font-size: 16px;" readonly>
                </div>

            </div><!--end form row-->

            <div class="col-lg-12">
                <div class="card-body text-center">
                        @php
                            $sum_order =0;
                            $sum_per =0;
                            $sum_total =0;
                        @endphp
                        <table class="table table-bordered  " id="datatable" >
                            <thead class="text-white bg-dark">
                                <tr>
                                    <th scope="col">Size</th>
                                    @foreach ($order['order_dt'] as $key =>$order_bc)

                                        <td>{{ $order_bc->XVOrderDSize  }}</td>
                                    @endforeach
                                    <th scope="col" style="width:150px">Total</th>

                                </tr>
                            </thead>

                            <tbody>
                                <tr>
                                    <td scope="row">จำนวน</td>
                                    @foreach ($order['order_dt'] as $key =>$order_bc)

                                        <td>{{ $order_bc->XIOrderDTotalNum }}</td>
                                        @php
                                            $sum_order += $order_bc->XIOrderDTotalNum;
                                        @endphp
                                    @endforeach
                                        <td>{{ number_format($sum_order)}}</td>
                                </tr>
                                <tr>
                                    <td scope="row">เริ่ม</td>
                                    @foreach ($order['order_bc'] as $key =>$order_bc)
                                        <td>{{ $order_bc->minBar }}</td>
                                    @endforeach
                                        <td>-</td>
                                </tr>
                                <tr>
                                    <td scope="row">สิ้นสุด</td>
                                    @foreach ($order['order_bc'] as $key =>$order_bc)
                                        <td>{{ $order_bc->maxBar}}</td>
                                    @endforeach

                                        <td>-</td>

                                </tr>

                            </tbody>
                        </table>
                    </div><!--card body-->
            </div><!--div-->

            <div  class="row">
                <div class="form-group col-md-4">
                    <label for="text">สถานที่เย็บ หน้าหลัง</label>
                    <select id="XISewCode" name="XISewCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;" readonly>
                        @foreach ($order['sews'] as $sews)
                          <option value="{{ $sews->XISewCode }}" {{ old('XISewCode', (isset($order['order_hd']) && $order['order_hd']->XISewCode == $sews->XISewCode) ? 'selected' : '') }}>{{ $sews->XVSewName }} </option>
                        @endforeach
                      </select>
                </div>
                <div class="form-group col-md-4">
                    <label for="text">สถานที่เย็บ รวมตัว</label>
                     <select id="XITotalSewCode" name="XITotalSewCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;" readonly>
                      @foreach ($order['totalsews'] as $totalsews)
                        <option value="{{ $totalsews->XITotalSewCode }}" {{ old('XITotalSewCode', (isset($order['order_hd']) && $order['order_hd']->XITotalSewCode == $totalsews->XITotalSewCode) ? 'selected' : '') }}>{{ $totalsews->XVTotalSewName }} </option>
                      @endforeach
                    </select>
                </div>
                <div class="form-group col-md-4">
                    <label for="text" >สถานที่เย็บ ฟอก</label>
                    <select id="XIAddBlenchCode" name="XIAddBlenchCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;" readonly>
                        @foreach ($order['blenchs'] as $blenchs)
                          <option value="{{ $blenchs->XIBlenchCode }}" {{ old('XIBlenchCode', (isset($order['order_hd']) && $order['order_hd']->XIAddBlenchCode == $blenchs->XIBlenchCode) ? 'selected' : '') }}>{{ $blenchs->XVBlenchName }} </option>
                        @endforeach
                      </select>
                </div>
            </div>



        </div><!--end card body-->
                          <div class="card-footer">
          <div class="row">
              <div class="col">
                <a href="{{route('admin.barcode.index')}}" class="btn btn-danger active" role="button" aria-pressed="true">{{ trans('global.back') }}</a>
              </div>

              <div class="col text-right">


                <div class="form-group row">
                    <label for="inputPassword" class="col-sm-2 col-form-label">Size : </label>
                    <select id="XVOrderBSize_export" name="XVOrderBSize_export" class="col-sm-7 form-control font-size" type="text">
                        @foreach ($order['order_bc'] as $key =>$order_bc)
                            <option value="{{ $order_bc->XVOrderBSize }}" >{{ $order_bc->XVOrderBSize }} </option>
                        @endforeach
                        </select>
                    <div class="col-sm-3">
                    <a href="#" id="btn_export" class="btn_submit btn btn-success active " data-status="2" type="button">Export Excel</a>
                    </div>
                </div>


              </div>
          </div>
      </div>
        </form>
    </div><!--end card-->


@endsection
{{-- @php
    foreach($order['order_dt'] as $res_dt){
        print $res_dt['XVOrderDSize'];

    }
@endphp --}}

@section('scripts')
<script type="text/javascript">
$( document ).ready(function() {
    // var table = $('#datatable').DataTable( {
    //     "scrollX": true,
    //     "searching": false,
    //     "bFilter": false,
    //     "paging":   false,
    //     "ordering": false,
    //     "info":     false,
    //     buttons: {
    //         buttons: [
    //         ]
    //     }
    // } );
    // table.buttons().disable();

    $("#eratedate_datepicker").datepicker()

    $('#btn_export').click(function(){
        size_code = $( "#XVOrderBSize_export" ).val();;
        window.location.href="{{ url("admin/barcodeExport").'/'.$order['XVOrderDocNo'].'/'}}"+size_code;
    })

})
</script>

@endsection
