@extends('layouts.admin')
@section('title', env('APP_NAME') . ' | ยืมคืน')
@section('style')
@section('content')

<div class="card">

    <div class="card-header">
        {{-- {{ trans('global.Torder_bc.title_singular') }} --}}
        ยืม - คืน
    </div>

    <div class="card-body">
        <div class="row">

            <div class="col-sm-12 pull-right">
                    <div class="btn-toolbar float-right">
                        <a href="{{ url('admin/borrow/create') }}" class="btn btn-success ml-1 active" data-toggle="tooltip" title="เพิ่มข้อมูล"><i class="fas fa-plus-circle"></i> เพิ่มข้อมูล</a>
                    </div>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table display" id="datatable"  style="width:100%">
                        <thead>
                            <tr>
                                {{-- <th width="10"></th> --}}
                                <th style="text-align:center" width="7%">รหัส</th>
                                <th style="text-align:center" width="10%">วันที่ยืม</th>
                                <th style="text-align:center" width="15%">SKU IN</th>
                                <th style="text-align:center" width="15%">Item Number</th>
                                <th style="text-align:center" width="8%">Size</th>
                                <th style="text-align:center" width="10%">จำนวน</th>
                                <th style="text-align:center" width="35%">ใครยืม (หมายเหตุ)</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {{-- {!! $roles->render() !!} --}}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div>
</div>

@endsection


@section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
@endsection
@section('scripts')
    <script>
        $(document).ready(function() {
            $('#datatable').DataTable( {
                // "processing": true,
                // "serverSide": true,
                pageLength: 10,
                "ajax": {
                    url : "{{url('')}}/admin/borrow/showtable",
                },
                "columnDefs": [
                    {
                        "targets": 0, // your case first column
                        "className": "text-center",
                    },
                    {
                        "targets": 1, // your case first column
                        "className": "text-center",
                    },
                    {
                        "targets": 2, // your case first column
                        "className": "text-left",
                    },
                    {
                        "targets": 3, // your case first column
                        "className": "text-left",
                    },
                    {
                        "targets": 4, // your case first column
                        "className": "text-center",
                    },
                    {
                        "targets": 5, // your case first column
                        "className": "text-right",
                    },
                    {
                        "targets": 6, // your case first column
                        "className": "text-left",
                    },
                ],
                "columns": [
                    { data: 'XIIOID'},
                    {
                        render: function(data, type, full ,meta){

                                return moment(full.XDIODate).format("DD-MM-YYYY");
                        }
                    },
                    { data: 'XVIOSKUin'},
                    { data: 'XVOrderIn'},
                    { data: 'XVStVkSize'},
                    { data: 'XIIONum'},
                    { data: 'XVOinoutNote'},

                ],
            } );
        })
    </script>
@endsection
