@extends('layouts.admin')

@section('title', 'หน้าจอเพิ่มแผนก | แก้ไข')

@section('content')
@php
    // dd($branch->XIBranchCode);

@endphp
  <form action="{{ route("admin.branch.update", [$branch->XIBranchCode]) }}" method="POST" enctype="multipart/form-data">
      @csrf
      @method('PUT')
    <div class="card">
        <div class="card-header">
            {{ trans('global.create') }}แผนก
        </div>

        <div class="card-body">

            <div class="form-group {{ $errors->has('XVBranchName') ? 'has-error' : '' }}">
                <label for="XVBranchName">ชื่อแผนก *</label>
                <input type="text" id="XVBranchName" name="XVBranchName" class="form-control" maxlength="191" value="{{ old('XVBranchName', isset($branch) ? $branch->XVBranchName : '') }}" required autofocus>
                @if($errors->has('XVBranchName'))
                    <em class="invalid-feedback">
                        กรุณากรอกชื่อแผนก
                    </em>
                @endif

            </div>

      </div>

      <div class="card-footer">
          <div class="row">
              <div class="col">
                <a href="{{route('admin.branch.index')}}" class="btn btn-danger active" role="button" aria-pressed="true">{{ trans('global.back') }}</a>
              </div>

              <div class="col text-right">
                <input class="btn btn-success active" type="submit" value="{{ trans('global.save') }}">
              </div>
          </div>
      </div>

    </div>

</form>
@endsection
