@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | แผนก ')

@section('content')

<div class="card">

  <div class="card-header">
      แผนก (สถานที่)
  </div>

    <div class="card-body">
        <div class="row">

            <div class="col-sm-12 pull-right">
                    <div class="btn-toolbar float-right">
                        <a href="{{ route('admin.branch.create') }}" class="btn btn-success ml-1 active" data-toggle="tooltip" title="เพิ่มข้อมูล"><i class="fas fa-plus-circle"></i> เพิ่มข้อมูล</a>
                    </div>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table  class="table table-bordered table-striped table-hover datatable">
                        <thead>
                            <tr>
                                {{-- <th width="10"></th> --}}
                                <th width="8%">รหัส</th>
                                <th>ชื่อ</th>
                                <th width="15%">จัดการ</th>
                            </tr>
                        </thead>
                        <tbody>

                          @foreach($resAll as $key => $res)
                              <tr data-entry-id="{{ $res->XIBranchCode }}">
                                  {{-- <td>

                                  </td> --}}
                                  <td>
                                      {{ $res->XIBranchCode ?? '' }}
                                  </td>
                                  <td>
                                      {{ $res->XVBranchName ?? '' }}
                                  </td>
                                  <td>

                                      @can('branch_edit')
                                        <a href="{{ route('admin.branch.edit', $res->XIBranchCode) }}" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="แก้ไข">
                                              <i class="fas fa-edit"></i>
                                          </a>
                                      @endcan

                                      @can('branch_delete')
                                            <form action="{{ route('admin.branch.destroy', $res->XIBranchCode) }}" method="POST" onsubmit="return confirm('{{ trans('global.areYouSure') }}');" style="display: inline-block;">
                                                <input type="hidden" name="_method" value="DELETE">
                                                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                                <button  type="submit" class="btn btn-danger"><i class="fas fa-trash"></i> {{ trans('global.delete') }}</button>
                                            </form>
                                      @endcan

                                  </td>

                              </tr>
                          @endforeach


                        </tbody>
                    </table>
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {{-- {!! $roles->render() !!} --}}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->

    @section('scripts')
    <script>
          $(function () {

              let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
              let deleteButton = {
                text: deleteButtonTrans,
                url: "{{ route('admin.branch.massDestroy') }}",
                className: 'btn-danger',
                action: function (e, dt, node, config) {
                  var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
                      return $(entry).data('entry-id')
                  });

                  if (ids.length === 0) {
                    alert('{{ trans('global.datatables.zero_selected') }}')

                    return
                  }

                  if (confirm('{{ trans('global.areYouSure') }}')) {
                    $.ajax({
                      headers: {'x-csrf-token': _token},
                      method: 'POST',
                      url: config.url,
                      data: { ids: ids, _method: 'DELETE' }})
                      .done(function () { location.reload() })
                  }
                }
              }

              let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)

            //   @can('branch_delete')
            //     dtButtons.push(deleteButton)
            //   @endcan

              $('.datatable:not(.ajaxTable)').DataTable({ buttons: dtButtons })
          })
    </script>
    @endsection

@endsection
