@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | ตรวจรับการจจัดส่ง')

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        ตรวจสอบสินค้า
                    </h4>
                </div><!--col-->
                <div class="col-sm-7 pull-right">
{{--                    <div class="btn-toolbar float-right">--}}
{{--                        <a href="{{ url('admin/importexcel/create') }}" class="btn btn-success ml-1" data-toggle="tooltip" title="เพิ่มข้อมูล"><i class="fas fa-plus-circle"></i></a>--}}
{{--                    </div>--}}
                </div><!--col-->
            </div><!--row-->

            <div class="row mt-4">
                <div class="col">
                    <div class="table-responsive " >
                        <table class="table display" id="datatable"  style="width:100%">
                            <thead>
                            <tr>
                                {{-- <th>#</th> --}}
                                <th>รหัสภายใน</th>
                                <th>รหัสสินค้า</th>
                                <th>Size</th>
                                <th>วันที่จัดส่งสินค้า</th>
                                <th>จำนวนออเดอร์</th>
                                <th>จำนวนสินค้า</th>
                            </tr>
                            </thead>

                        </table>

                    </div>
                </div><!--col-->
            </div><!--row-->
            <div class="row">
                <div class="col-7">
                    <div class="float-left">
                        {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                    </div>
                </div><!--col-->

                <div class="col-5">
                    <div class="float-right">
                        {{-- {!! $roles->render() !!} --}}
                    </div>
                </div><!--col-->
            </div><!--row-->
        </div><!--card-body-->
    </div><!--card-->
@endsection

@section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
@endsection
@section('scripts')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.24.0/moment.min.js"></script>

    <script>
        $(document).ready(function() {

            var t =$('#datatable').DataTable({
                "processing": true,
                "serverSide": false,
                pageLength: 10,
                "ajax": {
                    url : "{{url('')}}/admin/checkorder/checkproduct/GetData",
                    data:{_token: "{{csrf_token()}}"} ,
                    dataType: "json",
                    type: "POST",
                },
                "columns": [
                    // { data:'row' },
                    { data: 'XVOrderIn' },
                    { data: 'XVItemNo'},
                    { data: 'XVSize' },
                    {
                        render: function ( data, type, row ) {
                            console.log(row)
                            return moment(row.XDDateInDelivery).format('DD-MM-YYYY');

                        }
                    },
                    { data: 'XIOrderQty' },
                    { data: 'QtyOnHand' },

                ],
            });
        })
    </script>
@endsection

{{-- group order size --}}
