@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.edit') }} {{ trans('global.customers') }}
    </div>

    <div class="card-body">

        <form action="{{ route("admin.customer.update", [$Customer->XIGuestCode]) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="form-group {{ $errors->has('XVGuestName') ? 'has-error' : '' }}">
                <label for="name">{{ trans('global.TMcustomer.fields.XVGuestName') }}*</label>
                <input type="text" id="XVGuestName" name="XVGuestName" class="form-control" value="{{ old('XVGuestName', isset($Customer) ? $Customer->XVGuestName : '') }}">
                @if($errors->has('XVGuestName'))
                    <em class="invalid-feedback">
                        {{ $errors->first('XVGuestName') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.TMcustomer.fields.XVGuestName_helper') }}
                </p>
            </div>

            <div class="form-group {{ $errors->has('XVNameContact') ? 'has-error' : '' }}">
                <label for="price">{{ trans('global.TMcustomer.fields.XVNameContact') }}</label>
                <input type="text" id="XVNameContact" name="XVNameContact" class="form-control" value="{{ old('XVNameContact', isset($Customer) ? $Customer->XVNameContact : '') }}">
                @if($errors->has('XVNameContact'))
                    <em class="invalid-feedback">
                        {{ $errors->first('XVNameContact') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.TMcustomer.fields.XVNameContact_helper') }}
                </p>
            </div>

            <div class="form-group {{ $errors->has('XVGuestTel') ? 'has-error' : '' }}">
                <label for="price">{{ trans('global.TMcustomer.fields.XVGuestTel') }}</label>
                <input type="text" id="XVGuestTel" name="XVGuestTel" class="form-control" value="{{ old('XVGuestTel', isset($Customer) ? $Customer->XVGuestTel : '') }}" >
                @if($errors->has('XVGuestTel'))
                    <em class="invalid-feedback">
                        {{ $errors->first('XVGuestTel') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.TMcustomer.fields.XVGuestTel_helper') }}
                </p>
            </div>

            <div class="form-group {{ $errors->has('XVGuestAddress') ? 'has-error' : '' }}">
                <label for="XVGuestAddress">{{ trans('global.TMcustomer.fields.XVGuestAddress') }}</label>
                <textarea id="XVGuestAddress" name="XVGuestAddress" class="form-control ">{{ old('XVGuestAddress', isset($Customer) ? $Customer->XVGuestAddress : '') }}</textarea>
                @if($errors->has('XVGuestAddress'))
                    <em class="invalid-feedback">
                        {{ $errors->first('XVGuestAddress') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.TMcustomer.fields.XVGuestAddress_helper') }}
                </p>
            </div>

            <div>
                <input class="btn btn-danger" type="submit" value="{{ trans('global.save') }}">
            </div>
        </form>
    </div>
</div>

@endsection
