@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | Scan รับงานฟอก')
@php
    // dd($data[0]->XVOrderDocNo);
    // dd($rec);
@endphp
@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        รายละเอียด
                    </h4>
                </div><!--col-->
                <div class="col-sm-7 pull-right">
                    <div class="btn-toolbar float-right">
                        <a href="{{ url('admin/cutcloth') }}" class="btn btn-danger ml-1" data-toggle="tooltip" title="กลับ"><i class="fas fa-caret-square-left"></i></a>
                    </div>
                    {{-- <div class="btn-toolbar float-right">
                        <a href="{{ url('admin/order/report') }}" class="btn btn-info ml-2" data-toggle="tooltip" title="พิมพ์"><i class="fas fa-print"></i></a>
                    </div> --}}
                </div><!--col-->
                <div class="col-sm-7 pull-right">
                </div><!--col-->
            </div><!--row-->

            <div class="row mt-4">
                <div class="col">
                    <div class="table-responsive " >
                        <table class="table table-hover " style="width:100%">
                            <thead>
                            <tr>
                                <th width=10% style="text-align:center">NO</th>
                                <th width=10% style="text-align:center">เลขที่สั่งผลิต</th>
                                <th width=10% style="text-align:center">วันที่บันทึก</th>
                                <th width=15% style="text-align:left">Item Number</th>
                                <th width=10% style="text-align:center">Size</th>
                                <th width=5% style="text-align:center">โต๊ะ</th>
                                <th width=10% style="text-align:right">จำนวน</th>
                                <th width=15% style="text-align:left">ชื่อช่างตัด</th>
                                <th width=5% style="text-align:center">แก้ไข</th>
                                <th width=5% style="text-align:center">ลบ</th>
                            </tr>
                            </thead>
                            <tbody>
                             @foreach($data as $d )
                                <tr>
                                    <td style="text-align:center">{{ $d->XIIOID }}</td>
                                    <td style="text-align:center">{{ $d->XVOrderDocNo2 }}</td>
                                    <td style="text-align:center">{{ \Carbon\Carbon::parse($d->XDIODate)->format('d-m-y') }}</td>
                                    <td style="text-align:left">{{ $d->XVOrderIn }}</td>
                                    <td style="text-align:center">{{ $d->XVStVkSize }}</td>
                                    <td style="text-align:center">{{ $d->XIOrderTableCode }}</td>
                                    <td style="text-align:right">{{ $d->XIIONum }}</td>
                                    <td style="text-align:left">{{ $d->XVOinoutNote }}</td>
                                    <td style="text-align:center"><a href="{{url('admin/cutcloth/edit')}}/{{ $d->XIIOID }}" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="กดเพื่อแก้ไข"><i class="fas fa-edit"></i></a></td>
                                    <td style="text-align:center"><a href="{{url('admin/cutcloth/dele')}}/{{ $d->XIIOID }}" class="btn btn-danger" data-toggle="tooltip" data-placement="top" title="กดเพื่อลบ"><i class="fas fa-trash"></i></a></td>
                                </tr>
                             @endforeach
                            </tbody>
                        </table>
                    </div>
                </div><!--col-->
            </div><!--row-->
            <div class="row">
                <div class="col-7">
                    <div class="float-left">
                        {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                    </div>
                </div><!--col-->
                <div class="col-5">
                    <div class="float-right">
                        {{-- {!! $roles->render() !!} --}}
                    </div>
                </div><!--col-->
            </div><!--row-->
        </div><!--card-body-->
    </div><!--card-->
@endsection

@section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
@endsection

{{-- @section('scripts')
    <script>
        $(document).ready(function() {
            $('#datatable').DataTable( {
                // "processing": true,
                // "serverSide": true,
                pageLength: 10,
                "ajax": {
                    url : "{{url('')}}/admin/ordergetdata",
                    data:{location:5} ,
                },
                "columnDefs": [
                    {
                        "targets": 0, // เลขที่
                        "className": "text-center",
                    },
                    {
                        "targets": 1, // วันที่
                        "className": "text-center",
                    },
                    {
                        "targets": 2, // วันที่
                        "className": "text-center",
                    },
                    {
                        "targets": 3, // SKU
                        "className": "text-left",
                    },
                    {
                        "targets": 4, // Item Number
                        "className": "text-right",
                    },
                    {
                        "targets": 5, // Size
                        "className": "text-left",
                    },
                    {
                        "targets": 6, // จำนวน
                        "className": "text-right",
                    },
                    {
                        "targets": 7, // แก้ไข
                        "className": "text-center",
                    },
                ],
                "columns": [
                    { data: 'XVOrderDocNo'},
                    { data: 'XVOrderDocNo2'},
                    {
                        render: function(data, type, full ,meta){

                                return moment(full.XDOrderDocMDate).format("DD-MM-YYYY");
                        }
                    },
                    {
                        render: function(data, type, full ,meta){

                                return moment(full.XDOrderOut).format("DD-MM-YYYY");
                        }
                    },
                    { data: 'XVOrderIn'},
                    { data: 'XVOrderDSize'},
                    { data: 'XVOrderMItemNo'},
                    { data: 'XIOrderDTotalNum'},
                    {
                        render: function (data, type, full, meta ) {
                            // console.log(full);
                            return ' <a href="{{url('admin/cutcloth/create')}}/'+full.XVOrderDocNo+'" class="btn btn-success" data-toggle="tooltip" data-placement="top" title="กดเพื่อสร้าง Order"><i class="fas fa-truck-loading"></i></a>';
                        }
                    }

                ],
            } );
        })
    </script>
@endsection --}}

