@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | หน้าจอแก้ไข Size Barcode')

@section('content')
    <div class="card">
        <div class="card-header text-white bg-dark">
            แก้ไข Size Barcode
        </div>
        <div class="card-body">
            <div class="row">
                <div class="form-group col-md-3">
                    <label for="text">เลขที่ Barcode :</label>
                    {{-- <select id="XIGuestCode" name="XIGuestCode" class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                        {{-- <option value="">xxx</option>
                    </select> --}}
                    <input type="text" class="form-control" id="XVOrderBCode" placeholder="แสกนบาร์โค้ด">
                </div>
                <div class="form-group col-md-2">
                    <label for="text">Size เก่า :</label>
                    <input type="text" name="" class="form-control" value="" id="size" readonly >
                </div>
                <div class="col" style="margin-top:30px">
                    {{-- <a href="#" class="btn btn-success active ml-1 col-2" role="button">ค้นหา</a> --}}
                </div>
            </div>
            <div class="row">
                <div class="form-group col-md-2">
                    <label for="text">Size ใหม่ :</label>
                    {{-- <input type="text" name="" class="form-control"  id="XVOrderBSizeNew"> --}}
                    <select id="XVOrderBSizeNew"  class="col-sm-12 form-control font-size" type="text" required="required" style="font-size: 16px;">
                        <option disabled selected value> -- select--</option>
                        @foreach ($size as $size)
                             <option value="{{$size->size_id}}">{{ $size->size_name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col" style="margin-top:30px">
                    <a href="#" class="btn btn-success active ml-1 col-1" role="button" id="btnSave">บันทึก</a>
                    <a href="#" class="btn btn-danger active ml-1 col-1" role="button"  id="btnCancel">ยกเลิก</a>
                </div>
            </div>

        </div><!--end card body-->
    </div><!--end card-->

@endsection
@section('scripts')
<script>
    $(function () {
        $('#XVOrderBCode').focus();
        $("#XVOrderBCode").attr("disabled", false);
        $("#XVOrderBSizeNew").attr("disabled", true);

        $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
        });

        const Toast = Swal.mixin({
            toast: true,
            position: 'bottom-end',
            showConfirmButton: false,
            timer: 1000,
            timerProgressBar: true,
            onOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
        })

        //var count_scan = 0;
        $('#XVOrderBCode').keyup(function(e){
                if(e.keyCode == 13)
                {
                    $this = $(this);
                    if ($this.val().length != 18){

                        Swal.fire({
                        title: 'Oops....',
                        text: "เลขบาร์โค้ดไม่ถูกต้องกรุณาตรวจสอบ!",
                        icon: 'warning',
                        confirmButtonColor: '#3085d6',
                        confirmButtonText: 'OK'
                        }).then((result) => {
                            if (result.value) {
                                                return false;
                            }
                        })
                    }else{

                     // console.log('{{url('')}}/admin/editsizebarcodeCheck')
                     $.ajax({
                        type:'POST',
                        url:'{{url('')}}/admin/editsizebarcodeCheck',
                        data:{barcode: $this.val()},
                        dataType: 'JSON',
                        success:function(data){
                            //console.log(data)
                            if(data.success =="0"){
                                Swal.fire({
                                title: 'Oops....',
                                text: "ไม่พบข้อมูลในระบบกรุณาตรวจสอบ !",
                                icon: 'warning',
                                confirmButtonColor: '#3085d6',
                                confirmButtonText: 'OK'
                                }).then((result) => {
                                if (result.value) {
                                    $('#XVOrderBCode').val("")
                                    $('#size').val("")
                                }
                                })
                            }else if(data.success == "1"){

                                $('#size').val(data.size);
                                $("#XVOrderBSizeNew").focus();
                                $("#XVOrderBCode").attr("disabled", true);
                                $("#XVOrderBSizeNew").attr("disabled", false);
                            }
                        }
                        });
                    }
                }
        });


        $('#btnSave').click(function(e){
            var selectedSize = $('#XVOrderBSizeNew').children("option:selected").val();

             //if($('#XVOrderBSizeNew').children("option:selected").val().length == 0)
              if(selectedSize.length == 0)
             {
                Swal.fire({
                        title: 'Oops....',
                        text: "กรุณาเลือก Size ใหม่!",
                        icon: 'warning',
                        confirmButtonColor: '#3085d6',
                        confirmButtonText: 'OK'
                        }).then((result) => {
                            if (result.value) {
                              return false;
                            }
                        })
              }else{

                $.ajax({
                    type:'POST',
                    url:'{{url('')}}/admin/editsizebarcodeUpdateSize',
                    data:{barcode: $('#XVOrderBCode').val(),size: selectedSize},
                    dataType: 'JSON',
                    success:function(data){
                        if(data.success == '1'){
                                        Toast.fire({
                                            icon: 'success',
                                            title: 'แก้ไข Size สำเร็จ'
                                        })

                                        $("#XVOrderBCode").attr("disabled", false);
                                        $('#XVOrderBCode').val("");
                                        $('#size').val("");
                                        $('#XVOrderBCode').focus();
                                        $('#XVOrderBSizeNew option:first').prop('selected',true);
                                        $("#XVOrderBSizeNew").attr("disabled", true);
                        }

                    },
                     error: function(xhr, error){
                         Swal.fire({
                                title: 'Oops....',
                                text: "พบข้อผิดพลาดไม่สามารถแก้ไข Size ได้!",
                                icon: 'error',
                                confirmButtonColor: '#3085d6',
                                confirmButtonText: 'OK'
                        }).then((result) => {
                            if (result.value) {
                              return false;
                            }
                        })
                    }

                });

             }

        });

        $('#btnCancel').click(function(e){
            $("#XVOrderBCode").attr("disabled", false);
            $('#XVOrderBCode').val("");
            $('#size').val("");
            $('#XVOrderBCode').focus();
            $('#XVOrderBSizeNew option:first').prop('selected',true);
            $("#XVOrderBSizeNew").attr("disabled", true);
        });
    })
</script>
@endsection

