@extends('layouts.admin')

@section('title', 'หน้าจอแบบป้ายชื่อ | แก้ไข')

@section('content')
{{ html()->form('POST', '#')->class('form-horizontal')->open() }}
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        หน้าจอแบบป้ายชื่อ {{-- @lang('labels.backend.access.roles.management') --}}
                        <small class="text-muted">แก้ไข <!--@lang('labels.backend.access.roles.edit')--></small>
                    </h4>
                </div><!--col-->
            </div><!--row-->
            <!--row-->

            <hr />

            <div class="row mt-4">
                <div class="col">
                    <div class="form-group row">
                        {{ html()->label('รหัสแบบป้ายชื่อ/')
                            ->class('col-md-2 form-control-label') }} 

                        <div class="col-md-2">
                            {{ html()->text('name')
                                ->class('form-control')
                                ->placeholder(__('รหัสแบบป้ายชื่อ'))
                                ->attribute('maxlength', 191)
                                ->required()
                                ->autofocus() }} 
                        </div><!--col-->
                    </div><!--form-group-id-labelname-->
    
                    <div class="form-group row">
                        {{ html()->label('รายละเอียด/')
                            ->class('col-md-2 form-control-label') }} 

                        <div class="col-md-4">
                            {{ html()->textarea('name')
                                ->class('form-control')
                                ->placeholder(__('รายละเอียด'))
                                ->attribute('maxlength', 191)
                                ->required()
                                ->autofocus() }} 
                        </div><!--col-->
                    </div><!--form-group-detail-->

                    <div class="form-group row">
                        {{ html()->label('จำนวน/')
                            ->class('col-md-2 form-control-label') }} 

                        <div class="col-md-2">
                            {{ html()->text('name')
                                ->class('form-control')
                                ->placeholder(__('จำนวน'))
                                ->attribute('maxlength', 191)
                                ->required()
                                ->autofocus() }} 
                        </div><!--col-->
                    </div><!--form-group-quantity-->

                    <div class="form-group row">
                        {{ html()->label('ราคา/หน่วย/')
                            ->class('col-md-2 form-control-label') }} 

                        <div class="col-md-2">
                            {{ html()->text('name')
                                ->class('form-control')
                                ->placeholder(__('ราคา/หน่วย'))
                                ->attribute('maxlength', 191)
                                ->required()
                                ->autofocus() }} 
                        </div><!--col-->
                    </div><!--form-group-price/unit-->

                    <div class="form-group row">
                        {{ html()->label('รูป/')
                            ->class('col-md-2 form-control-label') }} 

                        <div class="col-md-2">
                            <input type="file">
                        </div><!--col-->
                    </div><!--form-group-picture-->
                </div><!--col-->
            </div><!--row-->
        </div><!--card-body-->

        <div class="card-footer">
            <div class="row">
                <div class="col">
                    {{ form_cancel(route('admin.labelname'), __('ยกเลิก')) }}
                </div><!--col-->

                <div class="col text-right">
                    {{ form_submit(__('บันทึก')) }}
                </div><!--col-->
            </div><!--row-->
        </div><!--card-footer-->
    </div><!--card-->
    {{ html()->form()->close() }}
@endsection
