@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | หน้าจอลูกค้า')

@section('content')

<div class="card">

  <div class="card-header">
      {{ trans('global.Torder_hd.title_singular') }}
  </div>

    <div class="card-body">
        <div class="row">

            <div class="col-sm-12 pull-right">
                    <div class="btn-toolbar float-right">
                        <a href="{{ route('admin.order.create') }}" class="btn btn-success ml-1 active" data-toggle="tooltip" title="เพิ่มข้อมูล"><i class="fas fa-plus-circle"></i> เพิ่มข้อมูล</a>
                    </div>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table  class="table table-bordered table-striped table-hover datatable">
                        <thead>
                            <tr>
                                {{-- <th width="10"></th> --}}
                                <th style="text-align:center" width="10%">เลขที่</th>
                                <th style="text-align:center" width="10%">วันที่อนุมัติ</th>
                                <th style="text-align:center" width="10%">วันที่ต้องจัดส่ง</th>
                                <th style="text-align:center" width="10%">Item No:</th>
                                <th style="text-align:center" width="13%">Order Type:</th>
                                <th style="text-align:center" width="13%">รหัสภายใน</th>
                                <th>รายละเอียด</th>
                                <th style="text-align:center"  width="15%">{{ trans('global.manage') }}</th>
                            </tr>
                        </thead>
                        <tbody>

                          @foreach($order as $key => $orders)
                              <tr data-entry-id="{{ $orders->XVOrderDocNo }}">
                                  {{-- <td>

                                  </td> --}}
                                  <td style="text-align:center" >
                                      {{ $orders->XVOrderDocNo ?? '' }}
                                  </td>
                                  <td style="text-align:center" >
                                    @switch($orders->XCStatus)
                                    @case(2)
                                        <span class="badge badge-success" style="cursor:pointer">{{ $orders->XDOrderDateApprove}}</span>
                                        @break
                                    @case(3)
                                        <span class="badge badge-danger" style="cursor:pointer">ยกเลิก</span>
                                            @break
                                    @case(4)
                                        <span class="badge badge-dark" style="cursor:pointer">ไม่อนุมัติ</span>
                                        @break
                                    @default
                                        <span class="badge badge-warning" style="cursor:pointer">รออนุมัติ</span>
                                    @endswitch
                                  </td>
                                  <td style="text-align:center" >
                                      {{ $orders->XDOrderOut ?? '' }}
                                  </td>
                                  <td style="text-align:center" >
                                      {{ $orders->XVOrderMItemNo ?? '' }}
                                  </td>
                                  <td style="text-align:center" >
                                    {{ $orders->XVOrderTName ?? '' }}
                                  </td>
                                  <td style="text-align:center" >
                                      {{ $orders->XVOrderIn ?? '' }}
                                  </td>

                                  <td>
                                      {{ $orders->XVOrderDetail ?? '' }}
                                  </td>


                                  {{--
                                  <td>
                                      {{ $orders->XVShapeName ?? '' }}
                                  </td>
                                   --}}
                                  <td style="text-align:center" >
                                      <div class="btn-group" role="group" >
                                      @can('order_approve')
                                        <a href="{{ route('admin.order.getApprove', $orders->XVOrderDocNo) }}" class="btn btn-success" data-toggle="tooltip" data-placement="top" title="อนุมัติ">
                                              <i class="fas fa-check"></i>
                                          </a>
                                      @endcan

                                      @can('order_edit')
                                        <a href="{{ route('admin.order.edit', $orders->XVOrderDocNo) }}" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="แก้ไข">
                                              <i class="fas fa-edit"></i>
                                          </a>
                                      @endcan

                                      @can('order_delete')
                                      <a href="#" name="confirm_item"
                                      data-id="{{$orders->XVOrderDocNo}}"
                                      data-status="{{$orders->XCStatus}}"
                                      class="btn btn-danger btn_del"
                                      data-toggle="tooltip"
                                      data-placement="top" title="ลบรายการ"
                                      >
                                            <i class="fas fa-trash"></i>
                                        </a>
                                            <form action="" method="POST" id="frm"  >
                                                <input type="hidden" name="_method" value="DELETE">
                                                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                            </form>
                                      @endcan
                                      </div>

                                  </td>

                              </tr>
                          @endforeach


                        </tbody>
                    </table>
                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {{-- {!! $roles->render() !!} --}}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
{{-- {{ route('admin.order.massDestroy') }} --}}
    @section('scripts')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
    <script>
          $(function () {


              $('.datatable:not(.ajaxTable)').DataTable({
                  "pageLength": 25,
              })

            $('.btn_del').click(function(){
                var $this  =$(this);

                if ($this.data('status') !="1"){
                    Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'ไม่สามารถยกเลิกรายการเลขที่ '+ $this.data('id') +' ได้ !'
                    })

                    return false;
                }

                Swal.fire({
                title: 'ยืนยันการยกเลิก ?',
                text: "คุณต้องการยกเลิกรายการเลขที่ "+ $this.data('id') +" ใช่หรือไม่ !",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'ยืนยัน !',
                cancelButtonText: 'ยกเลิก'
                }).then((result) => {
                if (result.value) {
                    $('#frm').attr('action','{{ url('admin/order/del') }}'+'/'+$this.data('id') )
                    $('#frm').submit();
                }
                })
            })
          })
    </script>
    @endsection

@endsection
