@extends('layouts.admin')

@section('title', env('APP_NAME') . ' |  ลูกค้าสั่ง PPE')

@section('content')
<div class="card border-light">
    <div class="card-header">
        กำหนดวันส่ง PPE
    </div>
    <div class="card-body">
        <div class="row">
            
        </div><!--row-->

        <div class="card border-light">
            {{-- <div class="card-header">
                บันทึกข้อมูล รับเข้า PPE
            </div> --}}
            <div class="card-body">
                <div class="row mt-4">
                    <div class="col">
                        <div class="table-responsive " >
                            <table class="table display" id="datatable"  style="width:100%">
                                <thead>
                                <tr>
                                    <th width="8%">เลขที่</th>
                                    <th width="20%">ผู้สั่ง</th>
                                    <th width="12%">กำหนดวันส่ง</th>
                                    <th width="7%">ISO</th>
                                    <th width="7%">Anti M</th>
                                    <th width="7%">Anti L</th>
                                    <th width="7%">Over M</th>
                                    <th width="7%">Over L</th>
                                    <th width="7%">Over XL</th>
                                    <th width="7%">Over 2XL</th>
                                    <th width="15%">Option</th>
                                </tr>
                                </thead>
        
                            </table>
        
                        </div>
                    </div><!--col-->
                </div><!--row-->        

            </div>
        </div>
        


        
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {{-- {!! $roles->render() !!} --}}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection

    @section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
    @endsection
    @section('scripts')
    <script>
        $(document).ready(function() {


            $('#datatable').DataTable( {
                // "processing": true,
                // "serverSide": true,
                pageLength: 10,
                "ajax": {
                    url : "{{url('')}}/admin/ppedategetdata",
                    data:{location:9} ,
                    },
                "columns": [
                    { data: 'XVPpeOrderId' },
                    { data: 'XVPpeContactName' },
                    {
                        render: function(data, type, full ,meta){

                                return moment(full.XDPpeSendDate).format("DD-MM-YYYY");
                        }
                    },
                    { data: 'Siso' },
                    { data: 'SantiM' },
                    { data: 'SantiL' },
                    { data: 'SoverM' },
                    { data: 'SoverL' },
                    { data: 'SoverXL' },
                    { data: 'Sover2XL' },
                    {
                        render: function (data, type, full, meta ) {
                            return ' <a href="{{url('admin/ppedate/edit')}}/'+full.XVPpeOrderId+'" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="แก้ไข"><i class="fas fa-edit"></i></a>';
                        }
                    }
                    
                ]
            } );
        })
    </script>
    @endsection

{{-- group order size --}}
