@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | รายงานสินค้าลงกล่อง')

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    รายงานสินค้าลงกล่อง
                </h4>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive " >
                    <table class="table display" id="datatable"  style="width:100%">
                        <thead>
                        <tr>
                            <th>วันที่</th>
                            <th>Number</th>
                            <th>รายละเอียด</th>
                            <th>Size</th>
                            <th>จำนวน</th>
                            <th>จัดการ</th>
                        </tr>
                        </thead>

                    </table>

                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {{-- {!! $roles->render() !!} --}}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection

    @section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
    @endsection
    @section('scripts')
    <script>
       $(document).ready(function() {
            var url = "{{route('admin.reportproductinbox.create')}}";
            $('#datatable').DataTable({
                "processing": true,
                "serverSide": true,
                pageLength: 10,
                "ajax": {
                    url : "{{url('')}}/admin/reportproductinboxGetData",
                    data:{_token: "{{csrf_token()}}",location:9} ,
                    dataType: "json",
                    type: "POST",
                    },
                "columnDefs": [
                    {
                        "targets": 4, // your case first column
                        "className": "text-right",
                    },
                ],
                "columns": [
                    { data: 'XDDate' },
                    { data: 'XVOrderIn' },
                    { data: 'XVOrderDetail' },
                    { data: 'XVOrderBSize' },
                    { data: 'XISizeCount' },
                    {
                        render: function ( data, type, row ) {
                            console.log(row)
                            // return '<a href="'+row.name+'">Edit</a>';
                            return '<a href="{{url('/admin/reportproductinbox/detail')}}/'+row.XDDate+'/'+row.XVOrderBSize+'/'+row.XVOrderIn+'"><button>รายละเอียด</button></a>';
                        }
                    }

                ]
            });

            {{--$('#datatable tbody').on( 'click', 'button', function () {--}}
            {{--    var cells = $(this).closest("tr").children("td");--}}
            {{--    var boxCode = cells.eq(0).text();--}}

            {{--    window.location.href = '{{url("admin/reportproductinboxDetail")}}/'+boxCode--}}
            {{--} );--}}
        })
    </script>
    @endsection

{{-- group order size --}}
