@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | Scan รับงานฟอก')

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        รายละเอียดรายการสินค้าที่เข้า Packing
                    </h4>
                </div><!--col-->

            </div><!--row-->

            <div class="row mt-4">
                <div class="col">
                    <div class="table-responsive " >
                        <table class="table display" id="datatable"  style="width:100%">
                            <thead>
                            <tr>
                                <th>วันที่</th>
                                <th>Barcoded</th>
                                <th>รหัสภายใน</th>
                                <th>Size</th>
                            </tr>
                            </thead>

                        </table>

                    </div>
                </div><!--col-->
            </div><!--row-->
            <div class="row">
                <div class="col-7">
                    <div class="float-left">
                        {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                    </div>
                </div><!--col-->
                <div class="col-5">
                    <div class="float-right">
                        {{-- {!! $roles->render() !!} --}}
                    </div>
                </div><!--col-->
            </div><!--row-->
        </div><!--card-body-->
    </div><!--card-->
@endsection

@section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
@endsection
@section('scripts')
    <script>
        $(document).ready(function() {
            var date = '{!! $date !!}'
            var size = '{!! $size !!}'
            var orderIn = '{!! $orderIn !!}'
            console.log(date,size);
            $('#datatable').DataTable( {
                // "processing": true,
                // "serverSide": true,
                pageLength: 10,
                "ajax": {
                    url : "{{url('')}}/admin/scanpackking/find/detail",
                    data:{date:date,
                        size:size,
                        location:13,
                        orderIn:orderIn,
                    } ,
                },
                "columns": [
                    { data: 'XDDate' },
                    { data: 'XVOrderBCode' },
                    { data: 'XVOrderIn' },
                    { data: 'XVOrderBSize' },
                ]
            } );
        })
    </script>
@endsection

