@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | Scan รับงานฟอก')

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    รายการสินค้าที่เข้า FG
                </h4>
            </div><!--col-->

            <div class="col-sm-7 pull-right">
                    <div class="btn-toolbar float-right">
                        <a href="{{ url('admin/scanstockfg/create') }}" class="btn btn-success ml-1" data-toggle="tooltip" title="เพิ่มข้อมูล"><i class="fas fa-plus-circle"></i></a>
                    </div>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive " >
                    <table class="table display" id="datatable"  style="width:100%">
                        <thead>
                        <tr>
                            <th>วันที่</th>
                            <th>เลขที่อ้างอิง</th>
                            <th>Number</th>
                            <th>รายละเอียด</th>
                            <th>Size</th>
                            <th>จำนวน</th>
                            <th>จัดการ</th>
                        </tr>
                        </thead>
                        <tfoot>
                        <tr>
                            <th colspan="4" style="text-align:right;color: red">Total:</th>
                            <th style="text-align: left;color: red"></th>
                            <th style="text-align: left;color: red"></th>
                        </tr>
                        </tfoot>
                    </table>

                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                </div>
            </div><!--col-->
            <div class="col-5">
                <div class="float-right">
                    {{-- {!! $roles->render() !!} --}}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection

    @section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
    @endsection
    @section('scripts')
    <script>
        $(document).ready(function() {
            $('#datatable').DataTable( {
                // "processing": true,
                // "serverSide": true,
                pageLength: 10,
                "ajax": {
                    url : "{{url('')}}/admin/scanstockfgGetData",
                    data:{location:5} ,
                    },
                "columnDefs": [
                    {
                        "targets": 5, // your case first column
                        "className": "text-right",
                    },
                ],
                "columns": [
                    { data: 'XDDate'},
                    { data: 'XVBcNoSand' },
                    { data: 'XVOrderIn'},
                    { data: 'XVOrderDetail'},
                    { data: 'XVOrderBSize'},
                    { data: 'XISizeCount'},
                    {
                        render: function ( data, type, row ) {
                            // console.log(row)
                            // return '<a href="'+row.name+'">Edit</a>';
                            return '<a href="{{url('/admin/scanstockfg/detail')}}/'+row.XDDate+'/'+row.XVOrderBSize+'/'+row.XVOrderIn+'"><button>รายละเอียด</button></a>';
                        }
                    }

                ],
                "footerCallback": function ( row, data, start, end, display ) {
                    var api = this.api(), data;
                    console.log()

                    // Remove the formatting to get integer data for summation
                    var intVal = function ( i ) {
                        return typeof i === 'string' ?
                            i.replace(/[\$,]/g, '')*1 :
                            typeof i === 'number' ?
                                i : 0;
                    };

                    // Total over all pages
                    total = api
                        .column( 5 )
                        .data()
                        .reduce( function (a, b) {
                            return intVal(a) + intVal(b);
                        }, 0 );

                    // Total over this page
                    pageTotal = api
                        .column( 5, { page: 'current'} )
                        .data()
                        .reduce( function (a, b) {
                            return intVal(a) + intVal(b);
                        }, 0 );

                    // Update footer
                    $( api.column( 4 ).footer() ).html(
                        ''+pageTotal
                    );
                }
            } );
        })
    </script>
    @endsection

