@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | ค่าฟอก')

@section('content')

<div class="card">

    <div class="card-header">
        {{-- {{ trans('global.Torder_hd.title_singular') }} --}}
        กำหนดราคางานฟอก
    </div>
      <div class="card-body">
         <div class="row">
              <div class="col-sm-12 pull-right">
              <div class="col">
                  <div class="table-responsive">
                      <table  class="table table-bordered table-striped table-hover datatable">
                          <thead>
                              <tr>
                                  {{-- <th width="10"></th> --}}
                                  <th style="text-align:center" width="10%">เลขที่</th>
                                  <th style="text-align:center" width="13%">รหัสภายใน</th>
                                  <th>รายละเอียด</th>
                                  <th style="text-align:center" width="13%">โรงฟอก</th>
                                  <th style="text-align:center" width="10%">ค่าฟอก</th>
                                  <th style="text-align:center"  width="15%">{{ trans('global.manage') }}</th>
                              </tr>
                          </thead>
                          <tbody>

                            @foreach($order as $key => $orders)
                                <tr data-entry-id="{{ $orders->XVOrderDocNo }}">
                                    {{-- <td>

                                    </td> --}}
                                    <td style="text-align:center" >
                                        {{ $orders->XVOrderDocNo ?? '' }}
                                    </td>
                                    <td style="text-align:center" >
                                        {{ $orders->XVOrderIn ?? '' }}
                                    </td>
                                    <td style="text-align:left" >
                                        {{ $orders->XVOrderDetail ?? '' }}
                                    </td>
                                    <td style="text-align:center" >
                                        {{ $orders->XVBlenchName ?? '' }}
                                    </td>
                                    <td style="text-align:right" >
                                        {{ number_format($orders->XDOrderBPrince,2) ?? '' }}
                                    </td>

                                    <td style="text-align:center" >
                                        <div class="btn-group" role="group" >


                                        @can('order_edit')
                                          <a href="{{ route('admin.setpricebleach.edit', $orders->XVOrderDocNo) }}" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="แก้ไข">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                        @endcan

                                        </div>

                                    </td>

                                </tr>
                            @endforeach


                          </tbody>
                      </table>
                  </div>
              </div><!--col-->
          </div><!--row-->
          <div class="row">
              <div class="col-7">
                  <div class="float-left">
                      {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                  </div>
              </div><!--col-->

              <div class="col-5">
                  <div class="float-right">
                      {{-- {!! $roles->render() !!} --}}
                  </div>
              </div><!--col-->
          </div><!--row-->
      </div><!--card-body-->
  </div><!--card-->
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
<script>
      $(function () {
          $('.datatable:not(.ajaxTable)').DataTable({
              "pageLength": 25,
          })
      })
</script>

@endsection
