@extends('layouts.admin')

@section('title', 'หน้าจอสถานที่เย็บ | เพิ่ม')

@section('content')

  <form action="{{ route("admin.sewinglocatin.update", [$sewinglocatin->XISewCode]) }}" method="POST" enctype="multipart/form-data">
      @csrf
      @method('PUT')
    <div class="card">
        <div class="card-header">
            {{ trans('global.create') }}{{ trans('global.sewinglocatin') }}
        </div>

        <div class="card-body">

            <div class="form-group {{ $errors->has('XVSewName') ? 'has-error' : '' }}">
                <label for="XVSewName">{{ trans('global.TMsew.fields.XVSewName') }}*</label>
                <input type="text" id="XVSewName" name="XVSewName" class="form-control" maxlength="191" value="{{ old('XVSewName', isset($sewinglocatin) ? $sewinglocatin->XVSewName : '') }}">
                @if($errors->has('XVSewName'))
                    <em class="invalid-feedback">
                        {{ $errors->first('XVSewName') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.TMsew.fields.XVSewName_helper') }}
                </p>
            </div>

            <div class="form-group {{ $errors->has('XISewTel') ? 'has-error' : '' }}">
                <label for="price">{{ trans('global.TMsew.fields.XISewTel') }}</label>
                <input type="text" id="XISewTel" name="XISewTel" class="form-control" maxlength="20" value="{{ old('XISewTel', isset($sewinglocatin) ? $sewinglocatin->XISewTel : '') }}" >
                @if($errors->has('XISewTel'))
                    <em class="invalid-feedback">
                        {{ $errors->first('XISewTel') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.TMsew.fields.XISewTel_helper') }}
                </p>
            </div>

            <div class="form-group {{ $errors->has('XVSewAddress') ? 'has-error' : '' }}">
                <label for="XVSewAddress">{{ trans('global.TMsew.fields.XVSewAddress') }}</label>
                <textarea id="XVSewAddress" name="XVSewAddress" class="form-control " maxlength="191">{{ old('XVSewAddress', isset($sewinglocatin) ? $sewinglocatin->XVSewAddress : '') }}</textarea>
                @if($errors->has('XVSewAddress'))
                    <em class="invalid-feedback">
                        {{ $errors->first('XVSewAddress') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.TMsew.fields.XVSewAddress_helper') }}
                </p>
            </div>

      </div>

      <div class="card-footer">
          <div class="row">
              <div class="col">
                <a href="{{route('admin.sewinglocatin.index')}}" class="btn btn-danger active" role="button" aria-pressed="true">{{ trans('global.back') }}</a>
              </div>

              <div class="col text-right">
                <input class="btn btn-success active" type="submit" value="{{ trans('global.save') }}">
              </div>
          </div>
      </div>

    </div>

</form>
@endsection
