@extends('layouts.admin')

@section('title', 'หน้าจอแบบทรง | แก้ไข')

@section('content')

  <form action="{{ route("admin.shape.update", [$shape->XIShapeCode]) }}" method="POST" enctype="multipart/form-data">
      @csrf
      @method('PUT')
    <div class="card">
        <div class="card-header">
            {{ trans('global.create') }}{{ trans('global.shapes') }}
        </div>

        <div class="card-body">

            <div class="form-group {{ $errors->has('XVShapeName') ? 'has-error' : '' }}">
                <label for="name">{{ trans('global.TMshape.fields.XVShapeName') }}*</label>
                <input type="text" id="XVShapeName" name="XVShapeName" class="form-control" maxlength="191" value="{{ old('XVShapeName', isset($shape) ? $shape->XVShapeName : '') }}" required autofocus>
                @if($errors->has('XVShapeName'))
                    <em class="invalid-feedback">
                        {{ $errors->first('XVShapeName') }}
                    </em>
                @endif
                <p class="helper-block">
                    {{ trans('global.TMshape.fields.XVShapeName_helper') }}
                </p>
            </div>

      </div>

      <div class="card-footer">
          <div class="row">
              <div class="col">
                <a href="{{route('admin.shape.index')}}" class="btn btn-danger active" role="button" aria-pressed="true">{{ trans('global.back') }}</a>
              </div>

              <div class="col text-right">
                <input class="btn btn-success active" type="submit" value="{{ trans('global.save') }}">
              </div>
          </div>
      </div>

    </div>

</form>
@endsection
