@extends('layouts.admin')

@section('title', env('APP_NAME') . ' | Scan รับงานฟอก')

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        รายการสินค้า
                    </h4>
                </div><!--col-->

            </div><!--row-->

            <div class="row mt-4">
                <div class="col">
                    <div class="table-responsive " >
                        <table class="table display" id="datatable"  style="width:100%">
                            <thead>
                            <tr>
                                <th>วันที่ลงทะเบียน</th>
                                <th>วันที่ได้รับการยืนยัน</th>
                                <th>รายละเอียด</th>
                                <th>จำนวน</th>
                            </tr>
                            </thead>

                        </table>

                    </div>
                </div><!--col-->
            </div><!--row-->
            <div class="row">
                <div class="col-7">
                    <div class="float-left">
                        {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                    </div>
                </div><!--col-->
                <div class="col-5">
                    <div class="float-right">
                        {{-- {!! $roles->render() !!} --}}
                    </div>
                </div><!--col-->
            </div><!--row-->
        </div><!--card-body-->
    </div><!--card-->
@endsection

@section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
@endsection
@section('scripts')
    <script>
        $(document).ready(function() {
            var id = '{!! $id !!}'
            console.log(id);
            $('#datatable').DataTable( {
                // "processing": true,
                // "serverSide": true,
                pageLength: 10,
                "ajax": {
                    url : "{{url('')}}/admin/getdata/type",
                    data:{
                        id:id,
                    },
                },"columnDefs": [
                {
                    "targets": 3, // your case first column
                    "className": "text-right",
                },
            ],
                "columns": [
                    { data: 'XDOrderDocMDate' },
                    { data: 'XDOrderDateApprove' },
                    { data: 'XVOrderDetail' },
                    { data: 'XIOrderDTotalNum' },
                ]
            } );
        })
    </script>
@endsection

