@extends('layouts.admin')

@section('title', env('APP_NAME') . ' |  ลูกค้าสั่ง PPE')

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Master Itemnumber
                </h4>
            </div><!--col-->

            <div class="col-sm-7 pull-right">
                    <div class="btn-toolbar float-right">
                        <a href="{{ url('admin/stockvk/create') }}" class="btn btn-success ml-1" data-toggle="tooltip" title="เพิ่มข้อมูล"><i class="fas fa-plus-circle"></i></a>
                    </div>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive " >
                    <table class="table display" id="datatable"  style="width:100%">
                        <thead>
                        <tr>
                            <th>รหัส</th>
                            <th>รหัสภายใน</th>
                            <th>Cost</th>
                            <th>Price</th>
                            <th>Color</th>
                            <th>แก้ไข</th>
                            <th>ลบ</th>

                        </tr>
                        </thead>

                    </table>

                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    {{-- {!! $roles->total() !!} {{ trans_choice('labels.backend.access.roles.table.total', $roles->total()) }} --}}
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    {{-- {!! $roles->render() !!} --}}
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
@endsection

    @section('styles')
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
    @endsection
    @section('scripts')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
    <script>
        @if(session('message'))
              Swal.fire({
                    title: "Message",
                    text: '{{session('message')}}',
                    icon: 'success',
                        })
        @endif
   </script>
    <script>
        $(document).ready(function() {


            $('#datatable').DataTable( {
                // "processing": true,
                // "serverSide": true,
                pageLength: 10,
                "ajax": {
                    url : "{{url('')}}/admin/stockvkgetdata",
                    data:{location:9} ,
                    },
                "columns": [
                    { data: 'XIStVkID' },
                    { data: 'XVOrderIn' },
                    { data: 'XFStVkCost' },
                    { data: 'XFStVkPrice' },
                    { data: 'XVStVkColor' },
                    {
                        render: function (data, type, full, meta ) {
                              return ' <a href="{{url('admin/stockvk/edit')}}/'+full.XIStVkID+'" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="แก้ไข"><i class="fas fa-edit"></i></a>';
                        }
                    },
                    {
                        render: function (data, type, full, meta ) {
                              return ' <a href="{{url('admin/stockvk/del')}}/'+full.XIStVkID+'" class="btn btn-danger" data-toggle="tooltip" data-placement="top" title="ลบ"><i class="fas fa-trash-alt"></i></a>';
                        }
                    }

                ],
                "columnDefs" :[
                    {   targets: 0,
                        className: "text-center"
                    },
                    {   targets: 1,
                        className: "text-left"
                    },
                    {   targets: 2,
                        className: "text-right"
                    },
                    {   targets: 3,
                        className: "text-right"
                    },
                    {   targets: 4,
                        className: "text-left"
                    },
                    {   targets: 5,
                        className: "text-left"
                    },
                    {   targets: 6,
                        className: "text-center"
                    }
                ]
            } );
        })
    </script>
    @endsection

{{-- group order size --}}
