@extends('layouts.app')
@section('style')
<style>
    body{

        background-color: rgba(238, 238, 238, 0.81) !important;
        background-image: url('{{url('/')}}/img/background.jpg');
        background-blend-mode: luminosity;
    }

</style>
@endsection
@section('content')
<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card-group">
            <div class="card p-4">
                <div class="card-body">
                    @if(\Session::has('message'))
                        <p class="alert alert-info">
                            {{ \Session::get('message') }}
                        </p>
                    @endif
                    <form method="POST" action="{{ route('login') }}" id="form1">
                        {{ csrf_field() }}
                        <h1>
                            <div class="login-logo" style="text-align: center;">
                                <img src="{{url('/')}}/img/logo.png" alt="Smiley face" height="100" width="115">
                            </div>
                        </h1>
                        <p class="text-muted">{{ trans('global.login') }}</p>
                        <div class="input-group mb-3">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="fa fa-user"></i></span>
                            </div>
                            <input name="email" id="username" type="text" class="form-control" placeholder="{{ trans('global.login_email') }}">
                        </div>
                        <div class="input-group mb-4">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="fa fa-lock"></i></span>
                            </div>
                            <input name="password" id="password" type="password" class="form-control" placeholder="{{ trans('global.login_password') }}">
                        </div>
                        <div class="row">
                            <div class="col-6">
                                <input type="submit" class="btn btn-primary px-4" value='{{ trans('global.login') }}'>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<script>
    $('#username').keypress(function(event) {
        if (event.keyCode == 13 || event.which == 13) {
            $('#password').focus();
            event.preventDefault();
        }
    });
    $('#password').keypress(function(event) {
        if (event.keyCode == 13 || event.which == 13) {
            $('#form1').submit();
            event.preventDefault();
        }
    });

</script>
@endsection

