@extends('layouts.admin')
@section('title', env('APP_NAME') . ' | home')
@section('style')
@section('content')
<style>
    *, ::after, ::before {
        box-sizing: border-box;
    }


    .bg-info, .bg-info > a {
        color: #fff !important;
    }

    .small-box {
        border-radius: .25rem;
        box-shadow: 0 0 1px rgba(0, 0, 0, .125), 0 1px 3px rgba(0, 0, 0, .2);
        display: block;
        margin-bottom: 20px;
        position: relative;
    }

    .small-box > .inner {
        padding: 10px;
        padding-bottom: 0px;
    }

    .small-box h3, .small-box p {
        z-index: 5;
    }

    .small-box h3 {
        font-size: 2.2rem;
        font-weight: 700;
        margin: 0 0 10px 0;
        padding: 0;
        white-space: nowrap;
    }

    .small-box h3, .small-box p {
        z-index: 5;
    }

    .small-box p + p {
        font-size: 1rem;
    }

    p {
        margin-top: 0;
        margin-bottom: 1rem;
    }

    p {
        display: block;
        margin-block-start: 1em;
        margin-block-end: 1em;
        margin-inline-start: 0px;
        margin-inline-end: 0px;
    }

    .small-box .icon {
        color: rgba(0, 0, 0, .15);
        z-index: 0;
    }

    .small-box .icon > i.fa, .small-box .icon > i.fab, .small-box .icon > i.far, .small-box .icon > i.fas, .small-box .icon > i.glyphicon, .small-box .icon > i.ion {
        font-size: 70px;
        top: 20px;
    }

    .small-box .icon > i {
        font-size: 90px;
        position: absolute;
        right: 15px;
        top: 15px;
        transition: all .3s linear;
    }

    .fa, .fas {
        font-weight: 900;
    }

    .fa, .far, .fas {
        font-family: "Font Awesome 5 Free";
    }

    .fa, .fab, .fad, .fal, .far, .fas {
        -moz-osx-font-smoothing: grayscale;
        -webkit-font-smoothing: antialiased;
        display: inline-block;
        font-style: normal;
        font-variant: normal;
        text-rendering: auto;
        line-height: 1;
    }

    .small-box > .small-box-footer {
        background: rgba(0, 0, 0, .1);
        color: rgba(255, 255, 255, .8);
        display: block;
        padding: 3px 0;
        position: relative;
        text-align: center;
        text-decoration: none;
        z-index: 10;
    }

    a {
        color: #007bff;
        text-decoration: none;
        background-color: transparent;
    }

    a:-webkit-any-link {
        color: -webkit-link;
        cursor: pointer;
        text-decoration: underline;
    }

    .bg-info {
        background-color: #17a2b89c !important;
    }

    .bg-green {
        background-color: #028900 !important;
    }

    .bg-purple {
        background-color: #ad44ae94 !important;
    }

    .bg-redbrown {
        background-color: #b83517 !important;
    }


    .bg-bluelight {
        background-color: #a1b6ff !important;
    }

    .bg-pink {
        background-color: #de296c !important;
    }

    .bg-greenlight {
        background-color: #c1c32c !important;
    }

    .bg-blue {
        background-color: #4c6ad5 !important;
    }

    .bg-yellow {
        background-color: #d1a320 !important;
    }
</style>
<div class="content">
    <div class="row">
        <div class="col-lg-4 col-md-6 col-sm-6 col-12">
            <div class="small-box bg-purple">
                <div class="inner">
                    <h3>{{$borrow}}</h3>
                    <p>ยืม-คืน</p>
                </div>
                <div class="icon iconsm">
                    <i class="fas fa-retweet"></i>
                </div>
                <a href="{{url('/admin/borrow')}}" class="small-box-footer">
                    Click เพื่อยืม/คืน  <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div>
        {{-- <div class="col-lg-4 col-md-6 col-sm-6 col-12">
            <div class="small-box bg-bluelight">
                <div class="inner">
                    <h3>{{$alldata}}</h3>
                    <p>สินค้าทั้งหมด</p>
                </div>
                <div class="icon iconsm">
                    <i class="fas fa-shopping-cart"></i>
                </div>
                <a href="{{url('/admin/borrow/show')}}" class="small-box-footer">
                    ข้อมูลเพิ่มเติม <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>
        </div> --}}
    </div>
</div>

@endsection
@section('scripts')

    @parent
@endsection
