<?php $__env->startSection('title', env('APP_NAME') . ' | Scan รับงานฟอก'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        เลือก Order ที่ลูกค้าสั่ง เพื่อลงโต๊ะตัด
                    </h4>
                </div><!--col-->
                <div class="col-sm-7 pull-right">
                    <div class="btn-toolbar float-right">
                        <a href="<?php echo e(url('admin/cutcloth')); ?>" class="btn btn-danger ml-1" data-toggle="tooltip" title="กลับ"><i class="fas fa-caret-square-left"></i></a>
                    </div>
                    
                </div><!--col-->
                <div class="col-sm-7 pull-right">
                </div><!--col-->
            </div><!--row-->

            <div class="row mt-4">
                <div class="col">
                    <div class="table-responsive " >
                        <table class="table display" id="datatable"  style="width:100%">
                            <thead>
                            <tr>
                                <th>NO</th>
                                <th>เลขที่สั่งผลิต</th>
                                <th>วันที่สร้าง</th>
                                <th>วันที่ต้องจัดส่ง</th>
                                <th>Item Number</th>
                                <th>Size</th>
                                <th>SKU Out</th>
                                <th>จำนวน</th>
                                <th>เลือก</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div><!--col-->
            </div><!--row-->
            <div class="row">
                <div class="col-7">
                    <div class="float-left">
                        
                    </div>
                </div><!--col-->
                <div class="col-5">
                    <div class="float-right">
                        
                    </div>
                </div><!--col-->
            </div><!--row-->
        </div><!--card-body-->
    </div><!--card-->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
            $('#datatable').DataTable( {
                // "processing": true,
                // "serverSide": true,
                pageLength: 10,
                "ajax": {
                    url : "<?php echo e(url('')); ?>/admin/ordergetdata",
                    data:{location:5} ,
                },
                "columnDefs": [
                    {
                        "targets": 0, // เลขที่
                        "className": "text-center",
                    },
                    {
                        "targets": 1, // วันที่
                        "className": "text-center",
                    },
                    {
                        "targets": 2, // วันที่
                        "className": "text-center",
                    },
                    {
                        "targets": 3, // SKU
                        "className": "text-left",
                    },
                    {
                        "targets": 4, // Item Number
                        "className": "text-right",
                    },
                    {
                        "targets": 5, // Size
                        "className": "text-left",
                    },
                    {
                        "targets": 6, // จำนวน
                        "className": "text-right",
                    },
                    {
                        "targets": 7, // แก้ไข
                        "className": "text-center",
                    },
                ],
                "columns": [
                    { data: 'XVOrderDocNo'},
                    { data: 'XVOrderDocNo2'},
                    {
                        render: function(data, type, full ,meta){

                                return moment(full.XDOrderDocMDate).format("DD-MM-YYYY");
                        }
                    },
                    {
                        render: function(data, type, full ,meta){

                                return moment(full.XDOrderOut).format("DD-MM-YYYY");
                        }
                    },
                    { data: 'XVOrderIn'},
                    { data: 'XVOrderDSize'},
                    { data: 'XVOrderMItemNo'},
                    { data: 'XIOrderDTotalNum'},
                    {
                        render: function (data, type, full, meta ) {
                            // console.log(full);
                            return ' <a href="<?php echo e(url('admin/cutcloth/create')); ?>/'+full.XVOrderDocNo+'/'+full.XVOrderIn+'/'+full.XVOrderDSize+'" class="btn btn-success" data-toggle="tooltip" data-placement="top" title="กดเพื่อสร้าง Order"><i class="fas fa-truck-loading"></i></a>';
                        }
                    }

                ],
            } );
        })
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/vk/resources/views/admin/cutcloth/index2.blade.php ENDPATH**/ ?>