<?php $__env->startSection('title', env('APP_NAME') . ' | ตรวจรับการจจัดส่ง'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    นำเข้าข้อมูล ใบกำกับกล่องสินค้า
                </h4>
            </div><!--col-->
             <div class="col-sm-7 pull-right">
                    <div class="btn-toolbar float-right">
                        <a href="<?php echo e(url('admin/importexcel/create')); ?>" class="btn btn-success ml-1" data-toggle="tooltip" title="เพิ่มข้อมูล"><i class="fas fa-plus-circle"></i></a>
                    </div>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive " >
                    <table class="table display" id="datatable"  style="width:100%">
                        <thead>
                        <tr>
                            
                            <th>รหัสสาขา</th>
                            <th>ใบสั่งซื้อ</th>
                            <th>รหัสภายใน</th>
                            <th>รายละเอียดสินค้า</th>
                            <th>ขนาด</th>
                            <th>จำนวน</th>
                            <th>วันที่จัดส่ง</th>

                        </tr>
                        </thead>

                    </table>

                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
<?php $__env->stopSection(); ?>

    <?php $__env->startSection('styles'); ?>
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('scripts'); ?>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.24.0/moment.min.js"></script>

    <script>
       $(document).ready(function() {

            var t =$('#datatable').DataTable({
                "processing": true,
                "serverSide": true,
                pageLength: 10,
                "ajax": {
                    url : "<?php echo e(url('')); ?>/admin/importexcelGetData",
                    data:{_token: "<?php echo e(csrf_token()); ?>",location:10} ,
                    dataType: "json",
                    type: "POST",
                    },
                "columns": [
                    // { data:'row' },
                    { data: 'XVStoreNbr' },
                    { data: 'XVPONbr'},
                    { data: 'XVOrderIn' },
                    { data: 'XVDescription' },
                    { data: 'XVSize' },
                    { data: 'XISupQty' },
                    {
                        render: function ( data, type, row ) {
                            return moment(row.XDDateInDelivery).format('DD-MM-YYYY');
                            // return row.XDDateInDelivery;

                        }
                    },
                ],
                "order": [[ 1, 'asc' ]]
            });

        //     t.on( 'order.dt search.dt', function () {
        //     t.column(0, {search:'applied', order:'applied'}).nodes().each( function (cell, i) {
        //         console.log(i+1)
        //         cell.innerHTML = i+1;
        //     } );
        // } ).draw();

            $('#datatable tbody').on( 'click', 'button', function () {
                var cells = $(this).closest("tr").children("td");
                var carCode = cells.eq(2).text();
                var DateInSend = cells.eq(1).text();

                 window.location.href = '<?php echo e(url("admin/importexcelGetData")); ?>/'+carCode+'/'+DateInSend
            } );
        })
    </script>
    <?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/vk/resources/views/admin/importexcel/index.blade.php ENDPATH**/ ?>