<?php $__env->startSection('title', env('APP_NAME') . ' |  ลูกค้าสั่ง PPE'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    ลูกค้าสั่ง PPE
                </h4>
            </div><!--col-->

            <div class="col-sm-7 pull-right">
                    <div class="btn-toolbar float-right">
                        <a href="<?php echo e(url('admin/ppe/create')); ?>" class="btn btn-success ml-1" data-toggle="tooltip" title="เพิ่มข้อมูล"><i class="fas fa-plus-circle"></i></a>
                    </div>
            </div><!--col-->
        </div><!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive " >
                    <table class="table display" id="datatable"  style="width:100%">
                        <thead>
                        <tr>
                            <th>เลขที่</th>
                            <th>Order</th>
                            <th>ชื่อผู้ติดต่อ</th>
                            <th>วันที่สั่ง</th>
                            <th>ชื่อผู้รับของ</th>
                            <th>ชำระเงิน</th>
                            <th>จัดส่ง</th>
                            <th>Option</th>
                        </tr>
                        </thead>

                    </table>

                </div>
            </div><!--col-->
        </div><!--row-->
        <div class="row">
            <div class="col-7">
                <div class="float-left">
                    
                </div>
            </div><!--col-->

            <div class="col-5">
                <div class="float-right">
                    
                </div>
            </div><!--col-->
        </div><!--row-->
    </div><!--card-body-->
</div><!--card-->
<?php $__env->stopSection(); ?>

    <?php $__env->startSection('styles'); ?>
    <link href="https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css" rel="stylesheet" />
    <?php $__env->stopSection(); ?>
    <?php $__env->startSection('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@9"></script>
    <script>
        <?php if(session('message')): ?>
              Swal.fire({
                    title: "Message",
                    text: '<?php echo e(session('message')); ?>',
                    icon: 'success',
                        })
        <?php endif; ?>
   </script>
    <script>
        $(document).ready(function() {


            $('#datatable').DataTable( {
                // "processing": true,
                // "serverSide": true,
                pageLength: 10,
                "ajax": {
                    url : "<?php echo e(url('')); ?>/admin/ppegetdata",
                    data:{location:9} , 
                    },
                "columns": [
                    { data: 'XIPpeCode' },
                    { data: 'XVPpeOrderId' },
                    { data: 'XVPpeContactName' },
                    //{ data: 'XDPpeOrderDate' },
                    {
                        render: function(data, type, full ,meta){

                                return moment(full.XDPpeOrderDate).format("DD-MM-YYYY");
                        }
                    },
                    { data: 'XVPpeRecipName' },
                   // { data: 'XVPpeStaSal' },
                   // { data: 'XVPpeStaSend' },
                    {
                        render: function (data, type, full, meta ) {
                            if(full.XVPpeStaSal){
                                    return '<span class="badge badge-success" style="cursor:pointer">ชำระแล้ว</span>'
                                 }else{
                                    return '<span class="badge badge-danger" style="cursor:pointer">ยังไม่ชำระ</span>'
                                 }
                        }
                    },
                    {
                        render: function (data, type, full, meta ) {
                            if(full.XVPpeStaSend){
                                    return '<span class="badge badge-success" style="cursor:pointer">จัดส่งแล้ว</span>'
                                 }else{
                                    return '<span class="badge badge-danger" style="cursor:pointer">ยังไม่จัดส่ง</span>'
                                 }
                        }
                    },
                    {
                        render: function (data, type, full, meta ) {
                            // console.log(full);

                              return ' <a href="<?php echo e(url('admin/ppe/edit')); ?>/'+full.XIPpeCode+'" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="แก้ไข"><i class="fas fa-edit"></i></a>';
                            //return '<a href="<?php echo e(url('admin/ppeedit')); ?>?id='+full.XIPpeCode+'"><button>แก้ไข</button></a>';
                        }
                    }

                ]
            } );
        })
    </script>
    <?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/vk/resources/views/admin/ppe/index.blade.php ENDPATH**/ ?>