<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BomController extends Controller
{


//    Should Check Deprecate

    public function FormInsert($pdtCode)
    {
        $product = DB::table('tmstmproduct')
            ->where('xvpdtcode', '=', $pdtCode)
            ->first();
        $mat_unit = DB::table('tmstmmat_unit')
            ->join('TMstMMaterial','tmstmmat_unit.xvmatcode','TMstMMaterial.xvmatcode')
            ->leftjoin('tmstmunit','tmstmunit.xvuntcode','tmstmmat_unit.xvuntcode')
            ->get()->toArray();
        $oldItem = DB::table('tmstmbom')->where('xvpdtcode', '=', $pdtCode)
            ->join('TMstMMaterial','tmstmbom.xvmatcode','TMstMMaterial.xvmatcode')
            ->leftjoin('tmstmunit','tmstmbom.xvuntcode','tmstmunit.xvuntcode')
            ->get();
        $data = [
            'Material' => $mat_unit,
            'Product' => $product,
            'oldItem'=>$oldItem
        ];
        return view('Bom.frm_add',$data);
    }

    public function store(Request  $request){
        try {
            DB::beginTransaction();
            DB::table('tmstmbom')->where('xvpdtcode','=',$request->xvpdtcode)->delete();
            for ($i = 0; $i < count($request->xvmatcode); $i++) {
                DB::table('tmstmbom')->insert([
                    'xvpdtcode' => $request->xvpdtcode,
                    'xvmatcode' => $request->xvmatcode[$i],
                    'xvuntcode' => $request->xvuntcode[$i],
                    'XIBomQty' => intval($request->XIBomQty[$i]),
                ]);
            }
            DB::commit();
            return redirect()->route('product.index')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }
}
