<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class FinishGoodReceiveController extends Controller
{
    public function index()
    {
        $HD = DB::table('tdoctfrhd')
            ->leftjoin('vk2_users', 'tdoctfrhd.XVFrhExaminer', 'vk2_users.id')
            ->orderBy('XVFrhDocNo', 'DESC')
            ->get();
        $HDAccept = DB::table('tdoctfrhd')
            ->where('XVFrhDocStatus', '=', '3')
            ->pluck('XVFrhDocNoOR');

        $RefHD = DB::table('TDocTOrHD')
            ->where('XVOrhDocStatus', '=', '3')
            ->whereNotIn('XVOrhDocNo',$HDAccept)
            ->leftJoin('tmstmproduct', 'TDocTOrHD.xvpdtcode', 'tmstmproduct.xvpdtcode')
            ->orderBy('XVOrhDocNo', 'DESC')
            ->get();
        $data = [
            'HD' => $HD,
            'RefHD' => $RefHD
        ];
        return view('FR.index', $data);
    }
    public function Approveindex()
    {
        $HD = DB::table('tdoctfrhd')
            ->leftjoin('vk2_users', 'tdoctfrhd.XVFrhExaminer', 'vk2_users.id')
            ->orderBy('XVFrhDocNo', 'DESC')
            ->where('XVFrhDocStatus','2')
            ->get();
        $HDAccept = DB::table('tdoctfrhd')
            ->where('XVFrhDocStatus', '=', '3')
            ->pluck('XVFrhDocNoOR');

        $RefHD = DB::table('TDocTOrHD')
            ->where('XVOrhDocStatus', '=', '3')
            ->whereNotIn('XVOrhDocNo',$HDAccept)
            ->leftJoin('tmstmproduct', 'TDocTOrHD.xvpdtcode', 'tmstmproduct.xvpdtcode')
            ->orderBy('XVOrhDocNo', 'DESC')
            ->get();
        $data = [
            'HD' => $HD,
            'RefHD' => $RefHD
        ];
        return view('FR.index', $data);
    }


    public function FormInsert($DocNo)
    {
        $oldHDFind = DB::table('tdoctfrhd')
            ->where('XVFrhDocNoOR', '=', $DocNo)
            ->whereIn('XVFrhDocStatus', ['1', '3'])
            ->first();
        if ($oldHDFind != null) {
            return redirect()->route('fr.edit', $oldHDFind->XVFrhDocNo)->with('msg', 'success');
        }
        $xvpdtcode = null;
        $hd = DB::table('TDocTOrHD')
            ->where('XVOrhDocNo', '=', $DocNo)
            ->first();
        $pdtImg = DB::table('tmstmproduct')
            ->where('xvpdtcode', '=', $hd->xvpdtcode)
            ->select('XVPdtImg')
            ->first();
        $xvpdtcode = $hd->xvpdtcode;
        $dt = DB::table('TDocTOrDT')
            ->where('XVOrhDocNo', '=', $DocNo)
            ->join('tmstmproduct', 'TDocTOrDT.xvpdtcode', '=', 'tmstmproduct.xvpdtcode')
            ->get();

        return view('FR.frm_add', [
            'hd' => $hd,
            'dt' => $dt,
            'xvpdtcode' => $xvpdtcode,
            'DocStatus' => $hd->XVOrhDocStatus,
        ]);
    }

    public function FormEdit($DocNo)
    {
        $hd = DB::table('tdoctfrhd')
            ->where('XVFrhDocNo', '=', $DocNo)
            ->leftjoin('TDocTOrHD', 'tdoctfrhd.XVFrhDocNoOR', 'TDocTOrHD.XVOrhDocNo')
            ->first();

        $dt = DB::table('tdoctfrdt')
            ->join('tmstmproduct', 'tdoctfrdt.xvpdtcode', '=', 'tmstmproduct.xvpdtcode')
            ->where('XVFrhDocNo', '=', $DocNo)->get();
        foreach ($dt as $item) {
            $dtOrder = DB::table('TDocTOrDT')
                ->where('XVOrhDocNo', '=', $hd->XVFrhDocNoOR)
                ->where('xvpdtcode', '=', $item->xvpdtcode)
                ->where('XVPszName', '=', $item->XVPszName)
                ->first();
            $item->XIOrdQty = $dtOrder->XIOrdQty;
        }
        $xvpdtcode = $hd->xvpdtcode ?? null;;


        $dataSend = [
            'hd' => $hd,
            'dt' => $dt,
            'xvpdtcode' => $xvpdtcode,
            'DocStatus' => $hd->XVFrhDocStatus,
        ];

        return view('FR.frm_edit', $dataSend);
    }

    public function Store(Request $request)
    {
        $date = Carbon::createFromFormat('d-m-Y', $request->XDFrhDocDate);
        try {
            DB::beginTransaction();
            $code = GeneratePrimaryKeyDate('tdoctfrhd', 'XVFrhDocNo', 'FR', 2);
            DB::table('tdoctfrhd')->insert([
                'XVFrhDocNo' => $code,
                'XDFrhDocDate' => $date->format('Y-m-d'),
                'XVFrhDocNoOR' => $request->XVOrhDocNo,
                'XVFrhDocStatus' => 1,
                'XVFrhDocRmk' => $request->XVFrhDocRmk,
                'XVFrhExaminer' => $request->SelectUsers,
            ]);
            foreach ($request->XVPszName as $key => $item) {
//                $itemFactor = DB::table('tmstmmat_unit')
//                    ->where('xvmatcode', '=', $request->xvmatcode[$key])
//                    ->where('xvuntcode', '=', $request->xvuntcode[$key])
//                    ->first();
                DB::table('tdoctfrdt')->insert([
                    'XVFrhDocNo' => $code,
                    'xvpdtcode' => $request->xvpdtcode[$key],
                    'XVPszName' => $request->XVPszName[$key],
                    'XIFrdQty' => $request->XIFrdQty[$key],
                ]);
            }
            DB::commit();
            return redirect()->route('fr.edit', $code)->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function Update(Request $request)
    {
        $date = Carbon::createFromFormat('d-m-Y', $request->XDFrhDocDate);
        try {
            DB::beginTransaction();
            $code = $request->XVFrhDocNo;
            DB::table('tdoctfrhd')
                ->where('XVFrhDocNo', '=', $code)
                ->update([
                    'XDFrhDocDate' => $date->format('Y-m-d'),
                    'XVFrhDocNoOR' => $request->XVOrhDocNo,
                    'XVFrhDocStatus' => 1,
                    'XVFrhDocRmk' => $request->XVFrhDocRmk,
                    'XVFrhExaminer' => $request->SelectUsers,
                ]);
            DB::table('tdoctfrdt')
                ->where('XVFrhDocNo', '=', $code)->delete();
            foreach ($request->XVPszName as $key => $item) {
//                $itemFactor = DB::table('tmstmmat_unit')
//                    ->where('xvmatcode', '=', $request->xvmatcode[$key])
//                    ->where('xvuntcode', '=', $request->xvuntcode[$key])
//                    ->first();
                DB::table('tdoctfrdt')->insert([
                    'XVFrhDocNo' => $code,
                    'xvpdtcode' => $request->xvpdtcode[$key],
                    'XVPszName' => $request->XVPszName[$key],
                    'XIFrdQty' => $request->XIFrdQty[$key],
                ]);
            }
            DB::commit();
            return redirect()->route('fr.edit', $code)->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function ChangeStatus(Request $request)
    {
        try {
            DB::beginTransaction();
            $docNo = $request->XVFrhDocNo;
            $requestChange = $request->eventRequest;
            $HD = DB::table('tdoctfrhd')
                ->where('XVFrhDocNo', '=', $docNo)
                ->first();
            $DocStatus = $HD->XVFrhDocStatus;
            switch ($requestChange) {
                case '2' : // Ask for Approve
                    if (canItBeSave($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't 1 or 4
                        // Do Someting
                    }
                    break;
                case '3' :  // Approve

                    if (canItBe_Approve_RequestChange($DocStatus)) {
                        $isNotBalancePreviosMonth = checkBalancePreviousMonth("tstktmatstockcardproduct");
                        if($isNotBalancePreviosMonth){
                            return redirect()->back()->with('msg', 'IsNotBalanced');
                        }
                        $Gihd =  DB::table('tdoctgihd')
                            ->where('XVGihDocNoOR', '=', $HD->XVFrhDocNoOR)
                            ->get();
                        if(count($Gihd)== 0){
                            return redirect()->back()->with('msg', 'unusagegi');
                        }
                        $this->UpdateStatus($docNo, $requestChange);
                        DB::table('tdoctorhd')
                            ->where('XVOrhDocNo', '=', $HD->XVFrhDocNoOR)
                            ->update([
                                'XBOrhIsReferedFR' => true,
                            ]);
                        $DT = DB::table('tdoctfrdt')
                            ->where('XVFrhDocNo', '=', $docNo)
                            ->get();
//                        $ORDT = DB::table('tdoctordt')
//                            ->where('XVOrhDocNo', '=', $HD->XVFrhDocNoOR);
                        $GI = DB::table('tdoctgidt')
                            ->join('tdoctgihd', 'tdoctgidt.XVGihDocNo', 'tdoctgihd.XVGihDocNo')
                            ->where('XVGihDocNoOR', '=', $HD->XVFrhDocNoOR)
                            ->where('XVGihDocStatus', '=', 3)
                            ->groupBy('xvmatcode')
                            ->select(DB::raw('SUM(XIGidQtyStk) as SumQtyStk'),
                                DB::raw('AVG(XFGidCostAvg) as AvgCost'),
                                DB::raw('(SUM(XIGidQtyStk) * AVG(XFGidCostAvg)) As Total '))
                            ->get();
                        $total = $GI->sum('Total');
                        $totalFrdQty = $DT->sum('XIFrdQty');
                        $price = $total / $totalFrdQty;
                        foreach ($DT as $item) {
                            DB::table('tstktmatstockcardproduct')
                                ->insert([
                                    'xvpdtcode' => $item->xvpdtcode,
                                    'xvpszname' => $item->XVPszName,
                                    'xvstkdocno' => $docNo,
                                    'xvstktype' => 1,
                                    'xistkqty' => $item->XIFrdQty,
                                    'xistkqtyuse' => 0,
                                    'xistkqtyleft' => $item->XIFrdQty,
                                    'xfstkcost' => $price,
                                    'xdstkdate' => $HD->XDFrhDocDate,
                                ]);
                            DB::table('tdoctfrdt')
                                ->where('XVFrhDocNo','=',$item->XVFrhDocNo)
                                ->where('xvpdtcode','=',$item->xvpdtcode)
                                ->where('XVPszName','=',$item->XVPszName)
                                ->update([
                                    'XFFrdCostTotal' => $price * $item->XIFrdQty,
                                    'XFFrdCostAvg' => $price,
                            ]);
//                            $bomReq = DB::table('tdoctormt')
//                                ->where('XVOrhDocNo', '=', $HD->XVFrhDocNoOR)
//                                ->where('xvpdtcode', '=', $item->xvpdtcode)
//                                ->where('XVPszName', '=', $item->XVPszName)
//                                ->get();
//                            $qtyorder =  $ORDT
//                                    ->where('xvpdtcode', '=', $item->xvpdtcode)
//                                    ->where('XVPszName', '=', $item->XVPszName)->first();
//                            dd($total,$total/$item->XIFrdQty,$qtyorder,$item,$bomReq,$totalFrdQty);

                        }
//
//
//                        dd($HD,$DT, $GI,$total,$total/$totalFrdQty);

                    } else {
                        // Can't Update Status Because DocStatus Isn't 2
                        // Do Someting
                    }
                    break;
                case '4' : // Requeste Change
                    if (canItBe_Approve_RequestChange($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't 2
                        // Do Someting
                    }
                    break;
                case '5' :
                    if (canItBe_Cancle($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't ( 1 , 2 , 4)
                        // Do Someting
                    }
            }
            DB::commit();
            return redirect()->back();
        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function UpdateStatus($docNo, $docStatus)
    {
        DB::table('tdoctfrhd')
            ->where('XVFrhDocNo', '=', $docNo)
            ->update([
                'XVFrhDocStatus' => $docStatus
            ]);
    }

    public function getDataForPDF($docNo)
    {
        $hd = DB::table('tdoctfrhd')
            ->where('XVFrhDocNo', '=', $docNo)
            ->leftjoin('vk2_users', 'tdoctfrhd.XVFrhExaminer', 'vk2_users.id')
            ->leftjoin('TDocTOrHD', 'tdoctfrhd.XVFrhDocNoOR', 'TDocTOrHD.XVOrhDocNo')
            ->leftjoin('tmstmproduct', 'TDocTOrHD.xvpdtcode', 'tmstmproduct.xvpdtcode')
            ->first();
        $dt = DB::table('tdoctfrdt')
            ->where('XVFrhDocNo', '=', $docNo)
            ->leftjoin('tmstmproduct', 'tdoctfrdt.xvpdtcode', 'tmstmproduct.xvpdtcode')
            ->get()
            ->toArray();
        $dataSend = [
            'hd' => $hd,
            'dt' => $dt,

        ];
        return response()->json($dataSend);
    }
}
