<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Report402Controller extends Controller
{
    //
    public function index()
    {
        return view('Report/index402');
    }
    public function data(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $MstItemStart = $request->input('MstItemStart');
        $MstItemEnd = $request->input('MstItemEnd');
        $isAllMst = $request->input("isAllMst") === 'true' ? true : false;
        //        Section Data
        $masteritem = DB::table('tmstmproduct');
        $masteritem = condition_LCR($masteritem, 'xvpdtcode', $isAllMst, $MstItemStart, $MstItemEnd);
        foreach ($masteritem as $item) {
            $OrderHD = DB::table('tdoctfrhd')
                ->where('XVFrhDocStatus', '=', '3')
                ->leftJoin('TDocTOrHD', 'tdoctfrhd.XVFrhDocNoOR', '=', 'TDocTOrHD.XVOrhDocNo')
                ->where('TDocTOrHD.xvpdtcode', '=', $item->xvpdtcode);
            $OrderHD = condition_LCR($OrderHD, 'XDOrhDocDate', $isAllTime, $DateStart, $DateEnd);
            if (count($OrderHD) > 0) {
                $item->OrderHD = $OrderHD;
                foreach ($item->OrderHD as $itemSecond) {
                    $OrderDT = DB::table('TDocTOrDT')
                        ->where('XVOrhDocNo', '=', $itemSecond->XVOrhDocNo);
                    $OrderDT = $OrderDT
                        ->select(DB::raw('SUM(XIOrdQty) as SumQty'))
                        ->first();
                    $FR_DT = DB::table('tdoctfrdt')
                        ->where('XVFrhDocNo', '=', $itemSecond->XVFrhDocNo)
                        ->select(DB::raw('SUM(XIFrdQty) as SumQty'))
                        ->first();
                    $itemSecond->SumOrder = $OrderDT->SumQty;
                    $itemSecond->SumFR = $FR_DT->SumQty;
                }
            } else {
                $item->OrderHD = [];
            }
        }
        return response()->json($masteritem);
    }
    public function datexcel(Request $request)
    {    //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $MstItemStart = $request->input('MstItemStart');
        $MstItemEnd = $request->input('MstItemEnd');
        $isAllMst = $request->input("isAllMst") === 'true' ? true : false;
        //        Section Data
        $data = DB::table('TDocTOrDT');
        $data  ->Join('TDocTOrHD', 'TDocTOrDT.XVOrhDocNo', '=', 'TDocTOrHD.XVOrhDocNo');
        $data  ->Join('tdoctfrhd', 'TDocTOrDT.XVOrhDocNo', '=', 'tdoctfrhd.XVFrhDocNoOR')
              ->Join('tmstmproduct', 'TDocTOrDT.xvpdtcode', '=', 'tmstmproduct.xvpdtcode')
              ->where('tdoctfrhd.XVFrhDocStatus', '=', '3');
        $data = condition_LCRVOutide($data, 'TDocTOrDT.xvpdtcode', $isAllMst, $MstItemStart, $MstItemEnd);
        $data = condition_LCRVOutide($data, 'TDocTOrHD.XDOrhDocDate', $isAllTime, $DateStart, $DateEnd);
        $data ->select('XVFrhDocNo','XDOrhDocDate','TDocTOrHD.XVOrhDocNo','XIOrdQty','TDocTOrDT.xvpdtcode');
        $data ->groupBy('XDOrhDocDate','XVFrhDocNo')
              ->select(DB::raw('SUM(XIOrdQty) as SumQty'),'XVFrhDocNo','XDOrhDocDate','TDocTOrHD.XVOrhDocNo','TDocTOrDT.xvpdtcode','xvpdtname');
           $data=$data->get();
           $i = 0;
         if (count($data) > 0) {
            foreach ($data as $itemSecond) {
                $FR_DT = DB::table('tdoctfrdt')
                    ->where('XVFrhDocNo', '=', $itemSecond->XVFrhDocNo)
                    ->select(DB::raw('SUM(XIFrdQty) as SumQty'))
                    ->first();
                    $itemSecond->SumFR = $FR_DT->SumQty;
                    $a[$i]=$itemSecond;
                    $i++;
            }
        } 
        else {
            $a = [];
        }

        return response()->json($a);
    }

}
