<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Report404Controller extends Controller
{
    //
    public function index()
    {
        return view('Report/index404');
    }

    public function data(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $MstItemStart = $request->input('MstItemStart');
        $MstItemEnd = $request->input('MstItemEnd');
        $isAllMst = $request->input("isAllMst") === 'true' ? true : false;
        //        Section Data
        $masteritem = DB::table('tmstmproduct');
        $masteritem = condition_LCR($masteritem, 'xvpdtcode', $isAllMst, $MstItemStart, $MstItemEnd);
        foreach ($masteritem as $item) {

            $OrderHD = DB::table('tdoctfidt')
                ->leftJoin('tdoctfihd','tdoctfidt.XVFihDocNo','tdoctfihd.XVFihDocNo')
                ->where('tdoctfidt.xvpdtcode', '=', $item->xvpdtcode)
                ->where('XVFihDocStatus', '=', '3')
                ->groupBy('tdoctfidt.XVFihDocNo','xvpdtcode','XDFihDocDate')
                ->select(DB::raw('SUM(XIFidQty) as SumQty'),'tdoctfidt.XVFihDocNo','XDFihDocDate');
            $OrderHD = condition_LCR($OrderHD, 'XDOrhDocDate', $isAllTime, $DateStart, $DateEnd);
            if (count($OrderHD) > 0) {
                $item->OrderHD = $OrderHD;
            } else {
                $item->OrderHD = [];
            }
        }
        return response()->json($masteritem);
    }

    public function datexcel(Request $request)
    {
           //        Section Data
           $DateStart = $request->input('DateStart');
           $DateEnd = $request->input('DateEnd');
           $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
           $MstItemStart = $request->input('MstItemStart');
           $MstItemEnd = $request->input('MstItemEnd');
           $isAllMst = $request->input("isAllMst") === 'true' ? true : false;
        //        Section Data

        $MstItem = DB::table('tdoctfidt');
        $MstItem ->Join('tdoctfihd', 'tdoctfihd.XVFihDocNo', '=', 'tdoctfidt.XVFihDocNo')
                 ->Join('tmstmproduct', 'tmstmproduct.xvpdtcode', '=', 'tdoctfidt.xvpdtcode')
                 ->where('tdoctfihd.XVFihDocStatus', '=', '3')
                 ->groupBy('tdoctfidt.XVFihDocNo','xvpdtcode','XDFihDocDate')
                ->select(DB::raw('SUM(XIFidQty) as SumQty'),'tdoctfidt.XVFihDocNo','XDFihDocDate','tdoctfidt.xvpdtcode','xvpdtname');
        $MstItem = condition_LCRVOutide($MstItem, 'tdoctfidt.xvpdtcode', $isAllMst, $MstItemStart, $MstItemEnd);
        $MstItem = condition_LCR($MstItem, 'XDFihDocDate', $isAllTime, $DateStart, $DateEnd);
        return response()->json($MstItem);
    }
}
