<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class UserManageController extends Controller
{
    public function index()
    {
        $users = DB::table('vk2_users')->orderBy('id', 'asc')->get()->toArray();
        foreach ($users as $item) {
            $item->role = DB::table('vk2_role_user')
                ->where('user_id', '=', $item->id)
                ->leftJoin('roles', 'vk2_role_user.role_id', 'roles.id')
                ->get();
        }
        $data = [
            'users' => $users
        ];
        return view('UserManagement.index', $data);
    }

    public function FormInsert()
    {
        return view('UserManagement.frm_add');
    }

    private function isDuplicate($field, $value, $oldID = null)
    {
        $cnt = DB::table('vk2_users')
            ->where($field, '=', $value);
        if($oldID!=null){
            $cnt = $cnt->where('id', '!=', $oldID);
        }
        $cnt = $cnt->count();
        if ($cnt > 0) {
            return true;
        } else {
            return false;
        }
    }

    public function Store(Request $request)
    {
        DB::beginTransaction();
        try {
            $isEmpCode_Dup = $this->isDuplicate('XVEmpCode', $request->XVEmpCode);
            if ($isEmpCode_Dup) {
                return redirect()->route('um.index')->with('msg', 'IsDuplicate_EmpCode');
            }
            $name_Dup = $this->isDuplicate('name', $request->name);
            if ($name_Dup) {
                return redirect()->route('um.index')->with('msg', 'IsDuplicate_EmpName');
            }
            $email_Dup = $this->isDuplicate('email', $request->email);
            if ($email_Dup) {
                return redirect()->route('um.index')->with('msg', 'IsDuplicate_email');
            }
            $id = DB::table('vk2_users')->insertGetId([
                'name' => $request->name,
                'XVEmpCode' => $request->XVEmpCode,
                'email' => $request->email,
                'password' => Hash::make($request->password),
                'XVCardID' => $request->XVCardID,
            ]);
            for ($i = 0; $i < count($request->SelectRole); $i++) {
                DB::table('vk2_role_user')->insertGetId([
                    'user_id' => $id,
                    'role_id' => $request->SelectRole[$i],
                ]);
            }
            for ($i = 0; $i < count($request->SelectMenus); $i++) {
                DB::table('vk2_user_menu')->insertGetId([
                    'user_id' => $id,
                    'menu_id' => $request->SelectMenus[$i],
                ]);
            }
            DB::commit();

            return redirect()->route('um.index')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function Update(Request $request)
    {
        DB::beginTransaction();
        try {
            $isEmpCode_Dup = $this->isDuplicate('XVEmpCode', $request->XVEmpCode,$request->id);
            if ($isEmpCode_Dup) {
                return redirect()->route('um.index')->with('msg', 'IsDuplicate_EmpCode');
            }
            $name_Dup = $this->isDuplicate('name', $request->name,$request->id);
            if ($name_Dup) {
                return redirect()->route('um.index')->with('msg', 'IsDuplicate_EmpName');
            }
            $email_Dup = $this->isDuplicate('email', $request->email,$request->id);
            if ($email_Dup) {
                return redirect()->route('um.index')->with('msg', 'IsDuplicate_email');
            }
            $id = $request->id;
            if ($request->password == null) {
                $update = [
                    'name' => $request->name,
                    'XVEmpCode' => $request->XVEmpCode,
                    'email' => $request->email,
                    'XVCardID' => $request->XVCardID,
                ];
            } else {
                $update = [
                    'name' => $request->name,
                    'XVEmpCode' => $request->XVEmpCode,
                    'email' => $request->email,
                    'password' => Hash::make($request->password),
                    'XVCardID' => $request->XVCardID,
                ];
            }
            DB::table('vk2_users')
                ->where('id', '=', $id)
                ->update($update);
            DB::table('vk2_role_user')->where('user_id', '=', $id)->delete();
            for ($i = 0; $i < count($request->SelectRole); $i++) {
                DB::table('vk2_role_user')->insert([
                    'user_id' => $id,
                    'role_id' => $request->SelectRole[$i],
                ]);
            }
            DB::table('vk2_user_menu')->where('user_id', '=', $id)->delete();
            for ($i = 0; $i < count($request->SelectMenus); $i++) {
                DB::table('vk2_user_menu')->insert([
                    'user_id' => $id,
                    'menu_id' => $request->SelectMenus[$i],
                ]);
            }
            DB::commit();
            return redirect()->back();
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function FormEdit($id)
    {
        $userData = DB::table('vk2_users')->where('id', '=', $id)->first();
        $userRole = DB::table('vk2_role_user')->where('user_id', '=', $id)->get();
        $userMenu = DB::table('vk2_user_menu')->where('user_id', '=', $id)->get();
        $data = [
            'users' => $userData,
            'role' => $userRole,
            'menu' => $userMenu
        ];
//        dd($data);
        return view('UserManagement.frm_edit', $data);
    }
}
