const miniMumRow = 25;
function countLineSpace(text){
    return Math.floor((text.length/20))*10;
}
function renderPdf(url) {
    fetch(url)
        .then(response => response.json())
        .then(async data => {
            // let line = countLineSpace(data.hd.XVCstAddress)
            let date = convertDateToLocale(data.hd.XDFihDocDate)
            let header = SectionHeader(date, data.hd.XVFihDocNo);
            let subHeader = SectionSubHeaderV3(date, data.hd);
            let ItemPo = ListItemPo(data.hd, data.dt);
            let Footer = await SectionFooter(data.hd)
            var dd = {
                pageSize: 'A4',
                // pageMargins: [20, 20],
                pageMargins: [20,200, 20, 20],
                header: function (currentPage, pageCount, pageSize) {
                    return {
                        stack: [...header, ...subHeader],
                        margin: [20, 15, 20, 0]
                    }
                },
                content: [
                    ...ItemPo,
                    ...remark(data.hd),
                    ...Footer
                ],
                // footer: function(currentPage, pageCount) {
                //     if (currentPage == pageCount)
                //         return {
                //             stack: [...remark(data.hd), ...Footer],
                //             // margin: [20, 15, 20, 0]
                //         }
                // },
                defaultStyle: {
                    font: "Sarabun",
                    fontSize: 7,

                }
            }
            pdfMake.createPdf(dd).open()
        });

}

// ซ้าย บน ขวา ล่าง

function SectionHeader(date, DocNo) {
    return [
        {
            text: 'บริษัท วี เค การ์เม้นท์ จำกัด',
            alignment: 'center',
            fontSize: 11,
            bold: true,
        },
        {
            text: '48, 50, 52, 54, 56, 126, 128, 130 ซอยสมเด็จพระเจ้าตากสิน 13 ถนนสมเด็จพระเจ้าตากสิน แขวงสำเหร่ เขตธนบุรี กรุงเทพมหานคร 10600',
            fontSize: 9,
            alignment: 'center'
        },
        {
            text: 'Tel: 02-860-7770 Fax: 02-438-9929',
            fontSize: 10,
            alignment: 'center'
        },
        {
            margin: [0, 5, 0, 0],
            text: "ใบเบิกสินค้า \n FINISH GOODS ISSUED",
            fontSize: 10,
            bold: true,
            alignment: 'center'
        },
        {
            alignment: 'justify',
            columns: [
                {
                    alignment: 'right',
                    text: 'FI No.' + DocNo,
                    fontSize: 11,
                    bold: true
                }
            ]
        },
    ]
}

function SectionSubHeaderV3(date, hd) {
    let usr_name = "สุชญา ภู่แสง (อิ๊บ)"
    let usr_phone = "02-8607770-4 ต่อ 131"
    let address = hd.XVCstAddress.replace(/(\r\n|\n|\r)/gm, "");
    return [
        {
            margin: [0, 5, 0, 0],

            table: {
                widths: [50, 150,70, '*'],
                body: [
                    [
                        {
                            text: 'Date : ',
                        },
                        {
                            text: date,
                        },

                        {
                            text: 'ผู้เบิกสินค้า :\n Issued By :',
                            rowSpan:2
                        },
                        {
                            text: hd.name ?? "",
                            rowSpan:2
                        },
                    ],
                    [
                        {
                            text: 'ชื่อลูกค้า : ',
                        },
                        {
                            text: hd.XVCstName,
                        },
                        {},
                        {},
                    ],
                    [
                        {
                            text: 'ผู้ติดต่อ : ',
                        },
                        {
                            text: hd.XVCstContacName,
                        },

                        {
                            text: 'เอกสารอ้างอิง : \n Ref. Doc. No. :',
                            rowSpan:2
                        },
                        {
                            text: hd.XVFihRefPO ?? "",
                            rowSpan:2
                        },
                    ],
                    [
                        {
                            text: 'Tel : ',
                        },
                        {
                            text: hd.XVCstPhone,
                        },
                        {},
                        {},
                    ],
                    [
                        {
                            text: address,
                            colSpan: 4
                        },
                        {},
                        {},
                        {},
                    ],
                ]
            },
            layout: {
                hLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 1 : 1;
                },
                vLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 1 : 1;
                },
                hLineColor: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 'black' : 'gray';
                },
                vLineColor: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 'black' : 'gray';
                },
            }
        },

    ]
}

function ListItemPo(hd, dt) {
    let DateReceive = hd.XDFihDocDateReceive ? convertDateToLocale(hd.XDFihDocDateReceive) : ""

    let {ItemPo ,Total,TotalPrice} = renderItemPo(dt,DateReceive);
    if (ItemPo.length <= miniMumRow) {
        ItemPo = renderEmpty(ItemPo)
    }
    return [
        {
            table: {
                widths: [27, 60, '*', 40, 60, 60],
                body: [
                    [
                        {text: 'ลำดับ', fontSize: 9, alignment: 'center'},
                        {text: 'รหัส', fontSize: 9, alignment: 'center'},
                        {text: 'รายการ', fontSize: 9, alignment: 'center'},
                        {text: 'ไซส์', fontSize: 9, alignment: 'center'},
                        {text: 'จำนวนที่เบิก', fontSize: 9, alignment: 'center'},
                        {text: 'ราคาต่อหน่วย', fontSize: 9, alignment: 'center'},
                    ],
                    ...ItemPo,
                    [
                        {text: 'รวม', colSpan: 4, fontSize: 9, alignment: 'center',fillColor: '#CCCCCC',},
                        {},
                        {},
                        {},
                        {text: formatMoney(Total), fontSize: 9, alignment: 'right',fillColor: '#CCCCCC',},
                        {text: formatMoney(TotalPrice), fontSize: 9, alignment: 'right',fillColor: '#CCCCCC',},

                    ],
                ]
            },

            layout: {
                fillColor: function (rowIndex, node, columnIndex) {
                    return (rowIndex === 0) ? '#CCCCCC' : null;
                },
                hLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 1 : 1;
                },
                vLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 1 : 1;
                },
                hLineColor: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 'black' : 'gray';
                },
                vLineColor: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 'black' : 'gray';
                },
            }
        },

    ]
}

function renderEmpty(ItemPo) {
    for (let i = ItemPo.length; i <= miniMumRow; i++) {
        ItemPo.push([
            {text: i + 1, fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
            {text: "", fontSize: 8, alignment: 'center'},
        ],)
    }
    return ItemPo
}

function renderItemPo(dt,DateReceive) {
    let ItemPo = []
    let Total = 0
    let TotalPrice = 0
    for (let i = 0; i < dt.length; i++) {
        Total = Total+ dt[i].XIFidQty;
        TotalPrice = TotalPrice+ dt[i].XFFidCostAvg;
        ItemPo.push([
            {text: i + 1, fontSize: 8, alignment: 'center'},
            {text: dt[i].xvpdtcode, fontSize: 8, alignment: 'center'},
            {text: dt[i].xvpdtname, fontSize: 8, alignment: 'left'},
            {text: dt[i].XVPszName, fontSize: 8, alignment: 'left'},
            {text: formatMoney(dt[i].XIFidQty), fontSize: 8, alignment: 'right'},
            {text: formatMoney(dt[i].XFFidCostAvg), fontSize: 8, alignment: 'right'},
        ],)
    }
    return {ItemPo,Total,TotalPrice}
}
function remark(hd){
    let Remark = hd.XVFihDocRmk ? hd.XVFihDocRmk : ''
    return [
        {
            table: {
                widths: ['*', '*', '*'],
                body: [
                    [
                        {
                            text: 'หมายเหตุ / Remarks :\n' + '\t'+Remark ,
                            colSpan: 3,
                            fontSize: 8,
                            alignment: 'left',
                            preserveLeadingSpaces: true,
                        },
                    ],
                ]
            },
        },

    ]
}
async function SectionFooter(hd) {
    return [
        {
            table: {
                heights: function (row) {
                    return row === 1 ? 40 : 0
                },
                widths: ['*', '*', '*'],
                body: [
                    [
                        {text: 'เบิกสินค้าโดย \nIssued By', fontSize: 10, alignment: 'center', border: [true, false]},
                        {text: 'ตรวจสอบโดย \nChecked By ', fontSize: 10, alignment: 'center', border: [true, false]},
                        {
                            text: 'อนุมัติโดย \nApproved By',
                            fontSize: 10,
                            alignment: 'center',
                            border: [true, false, true, false]
                        },
                    ],
                    [
                        {
                            text: '\n.............................',
                            fontSize: 10,
                            alignment: 'center',
                            margin: [0, 15, 0, 0], border: [true, false]
                        },
                        {
                            text: '\n.............................',
                            fontSize: 10,
                            alignment: 'center',
                            margin: [0, 15, 0, 0], border: [true, false]
                        },
                        {
                            text: '\n.............................',
                            fontSize: 10,
                            alignment: 'center',
                            margin: [0, 15, 0, 0], border: [true, false, true, false]
                        },
                    ],
                    [
                        {text: '', fontSize: 10, alignment: 'center', border: [true, false]},
                        {
                            text: '',
                            fontSize: 10,
                            alignment: 'center',
                            border: [true, false]
                        },
                        {text: '', fontSize: 10, alignment: 'center', border: [true, false, true, false]},
                    ],

                    [
                        {
                            text: '......../......../........', fontSize: 10,
                            alignment: 'center',
                            // border: [true, false]
                        },
                        {
                            text: '......../......../........',
                            fontSize: 10,
                            alignment: 'center',
                            // border: [true, false]
                        },
                        {
                            text: '......../......../........',
                            fontSize: 10,
                            alignment: 'center',
                            // border: [true, false, true, false]
                        },
                    ],


                ]
            },

            layout: {
                hLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 1 : 1;
                },
                vLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 1 : 1;
                },
                hLineColor: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 'black' : 'gray';
                },
                vLineColor: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 'black' : 'gray';
                },
            }
        },

    ]
}

//Utility

function formatMoney(amount, decimalCount = 2, decimal = ".", thousands = ",") {
    try {
        decimalCount = Math.abs(decimalCount);
        decimalCount = isNaN(decimalCount) ? 2 : decimalCount;

        const negativeSign = amount < 0 ? "-" : "";

        let i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
        let j = (i.length > 3) ? i.length % 3 : 0;

        return negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
    } catch (e) {
        console.error(e)
    }
};

function getBase64ImageFromURL(url) {
    return new Promise((resolve, reject) => {
        var img = new Image();
        img.setAttribute("crossOrigin", "anonymous");
        img.onload = () => {
            var canvas = document.createElement("canvas");
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext("2d");
            ctx.drawImage(img, 0, 0);
            var dataURL = canvas.toDataURL("image/png");
            resolve(dataURL);
        };
        img.onerror = error => {
            reject(error);
        };
        img.src = url;
    });
}

function convertDateToLocale(date) {
    return new Date(date).toLocaleDateString('th')
}
