const miniMumRow = 30;
const HeaderName = "102 รายงานการสั่งผลิตแยกตามสินค้า";
const column = 6;

function countLineSpace(text) {
    return Math.floor((text.length / 20)) * 10;
}

function renderPdf(result,filter) {
    let header = SectionHeader(filter);
    let SubHeaderX = SubHeader();

    let ListItems = ListItem(result);
    var dd = {
        pageSize: 'A4',
        // pageMargins: [20, 20],
        pageMargins: [20, 86, 20, 20],
        header: function (currentPage, pageCount, pageSize) {
            return {
                stack: [...header,...SubHeaderX],
                margin: [20, 15, 20, 0]
            }
        },
        content: [
            ...ListItems,
        ],
        defaultStyle: {
            font: "Sarabun",
            fontSize: 7,

        }
    }
    pdfMake.createPdf(dd).open()
}

// ซ้าย บน ขวา ล่าง

function SectionHeader(filter) {

    let DateStart,DateEnd,CstNameStart,CstNameEnd
    if(!!filter.isAllTime){
         DateStart = "ทั้งหมด"
         DateEnd = "ทั้งหมด"
    }else{
         DateStart = convertDateToLocale(filter.DateStart)
         DateEnd = convertDateToLocale(filter.DateEnd)
    }
    if(!!filter.isAllMst){
         CstNameStart = "ทั้งหมด"
         CstNameEnd = "ทั้งหมด"
    }else{
         CstNameStart = (filter.MstItemStart)
         CstNameEnd = (filter.MstItemEnd)
    }
    return [
        {
            text: HeaderName,
            alignment: 'center',
            fontSize: 11,
            bold: true,

        },
        {
            text: `จากวันที่ ${DateStart}  ถึงวันที่ ${DateEnd}`,
            alignment: 'center',
            fontSize: 10,
            bold: false,
        },
        {
            text: `จากสินค้า ${CstNameStart}\nถึง ${CstNameEnd}`,
            alignment: 'center',
            fontSize: 10,
            bold: false,
        },
    ]
}

function SubHeader() {
    return [
        {
            table: {
                widths: [120, 60, '*', 80],
                body: [
                    [
                        {text: 'สินค้า', fontSize: 9, alignment: 'left',   border: [true, true,true,true]},
                        {text: 'วันที่', fontSize: 9, alignment: 'left',   border: [true, true,true,true]},
                        {text: 'เลขที่ใบสั่งผลิต', fontSize: 9, alignment: 'left', border: [true, true,true,true]},
                        {text: 'จำนวน', fontSize: 9, alignment: 'left',  border: [true, true,true,true]},
                    ],
                ]
            },

            layout: {
                fillColor: function (rowIndex, node, columnIndex) {
                    return (rowIndex === 0 ) ? '#CCCCCC' : null;
                },
                hLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 1 : 1;
                },
                vLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 1 : 1;
                },
                hLineColor: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 'black' : 'gray';
                },
                vLineColor: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 'black' : 'gray';
                },
            }
        },

    ]
}
function ListItem(result) {
    let arrayItems = [] ;
    for(let i = 0 ; i < result.length ; i++){
        let {Items,SumToTalQty} = renderItem(result[i]);
        if(Items.length >0){
            Items = renderSumRow(SumToTalQty,Items);
        }
        arrayItems = [...arrayItems,...Items]
    }
    return [
        {
            table: {
                widths: [120, 60, '*', 80],
                body: [
                    ...arrayItems,
                ]
            },
        },

    ]
}
function renderItem({xvpdtcode,xvpdtname,OrderHD}) {
    let Item = []
    let SumToTalQty = 0 ;

    for (let i = 0; i < OrderHD.length; i++) {
        const {XVOrhDocNo,XDOrhDocDate,XIOrdQty} = OrderHD[i];
        SumToTalQty = SumToTalQty+parseInt(XIOrdQty);

        const oldValue = OrderHD[i-1] ?? {XVOrhDocNo :null , XDOrhDocDate:null};
        let DateDisplay , GlobalHeader;
        if(XDOrhDocDate == oldValue.XDOrhDocDate){
            DateDisplay=""
            if( i == OrderHD.length-1){
                GlobalHeader = {border: [true, false,true,true]}
            }else{
                GlobalHeader = {border: [true, false,true,false]}
            }

        }else{
            DateDisplay = convertDateToLocale(XDOrhDocDate)
            GlobalHeader = {border: [true, true,true,false]}
        }
        let NameDisplay = i == 0 ? `${xvpdtcode+" "+xvpdtname}`:'';
        const DetailBorder = (i == OrderHD.length-1) ? {border: [true, false,true,true]} : {border: [true, false,true,false]}

        if(i == 0 ){
            Item.push([
                {text: NameDisplay, fontSize: 8, alignment: 'left',rowSpan:OrderHD.length,...DetailBorder},
                {text: DateDisplay, fontSize: 8, alignment: 'center',...GlobalHeader},
                {text: XVOrhDocNo, fontSize: 8, alignment: 'left',...DetailBorder},
                {text: formatMoney(XIOrdQty,0,''), fontSize: 8, alignment: 'left',...DetailBorder},
            ],)
        }else{
            Item.push([
                {},
                {text: DateDisplay, fontSize: 8, alignment: 'center',...GlobalHeader},
                {text: XVOrhDocNo, fontSize: 8, alignment: 'left',...DetailBorder},
                {text: formatMoney(XIOrdQty,0,''), fontSize: 8, alignment: 'left',...DetailBorder},
            ],)
        }

    }
    return {Items: Item , SumToTalQty}
}
function renderSumRow(Total,Items){
    Items.push([
        {text: "\tรวม", fontSize: 8, alignment: 'center',preserveLeadingSpaces: true,colSpan:3},
        {},
        {},
        {text: formatMoney(Total,0,''), fontSize: 8, alignment: 'right'},
    ],)
    return Items;
}
//Utility


function formatMoney(amount, decimalCount = 2, decimal = ".", thousands = ",") {
    try {
        decimalCount = Math.abs(decimalCount);
        decimalCount = isNaN(decimalCount) ? 2 : decimalCount;

        const negativeSign = amount < 0 ? "-" : "";

        let i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
        let j = (i.length > 3) ? i.length % 3 : 0;

        return negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
    } catch (e) {
        console.error(e)
    }
};

function convertDateToLocale(date) {
    return new Date(date).toLocaleDateString('th')
}
