@php
    $today = Carbon\Carbon::now()->format('d-m-Y')
@endphp


<div class="form-group row mt-2 mb-1 pb-0">
    <label class="col-md-4  col-xl-2 col-form-label">เลขที่เอกสาร</label>
    <div class="col-3">
        <input type="text" class="form-control" name="XVGrhDocNo"
               value="{{$oldHD->XVGrhDocNo ?? getTempPKGen('GR')}}"
               readonly>
    </div>

    <label class="col-md-4  col-xl-2 col-form-label">วันที่เอกสาร</label>
    <div class="col">
        <div class="input-group">
            <input class="form-control " readonly name="XDGrhDocDate"
                   width="150"
                   id="datepicker"
                   autocomplete="off"
                   value="{{isset($oldHD->XDGrhDocDate) ? date_YmdTodmY($oldHD->XDGrhDocDate) : $today}}"
                   style="background-color: #fff;">
        </div>
    </div>
</div>
<div class="dropdown-divider"></div>

<div class="form-group row mt-3 pb-0">
    <label class="col-3 col-form-label">เลขที่เอกสารอ้างอิง (PO)</label>
    <div class="col-4">
        <div class="input-group ">
            <input type="text" class="form-control" name="XVPohDocNo"
                   @if(isset($oldHD->XVPohDocNo)) value="{{$oldHD->XVPohDocNo ?? "Poh####-######"}}" @endif
                   @if(isset($oldHD->XVGrhDocNoPO)) value="{{$oldHD->XVGrhDocNoPO ?? "Poh####-######"}}" @endif
                   readonly>
            <div class="input-group-append">
                {{-- @if(isset($oldHD->XVGrhDocNoPO))<a href="{{route('po.edit',$oldHD->XVGrhDocNoPO)}}" target="_blank" class="btn btn-outline-info">ไปหน้า PO</a> @endif --}}
                @if(isset($oldHD->XVGrhDocNoPO))   <a href="#" type="button" class="btn btn-info" onclick="renderPdfPo('{{route('po.getOld',['docNo'=>$oldHD->XVGrhDocNoPO])}}')"><i class="far fa-file-pdf"></i> PDF</a> @endif

                
            </div>
        </div>

    </div>
</div>
<div class="form-group row mb-1 pb-0">
    <label class="col-md-4  col-xl-2 col-form-label">ชื่อผู้รับวัสดุ</label>
    <div class="col">
        @component('Components.UsersForGR',['isRequired'=>true,'oldValue'=>$oldHD->XIGrhUsrID ?? null])
        @endcomponent
    </div>
</div>
<div class="form-group row mb-1 pb-0" style="display: none">
    <label class="col-md-4  col-xl-2 col-form-label">เลขที่ใบขอซื้อ</label>
    <div class="col">
        <input type="text" class="form-control"
               readonly
               @if(isset($oldHD->XVPohRefNo)) value="{{$oldHD->XVPohRefNo ?? ""}}" @endif
               @if(isset($oldHD->XVGrhRefNo)) value="{{$oldHD->XVGrhRefNo ?? ""}}" @endif
               name="XVPohRefNo" id="XVPohRefNo">
    </div>
</div>
<div class="form-group row mb-1 pb-0" style="display: none">
    <label class="col-md-4  col-xl-2 col-form-label">เงื่อนไขการชำระ</label>
    <div class="col">
        <div class="input-group">
            <input type="text" class="form-control" name="XVPohBillDays"
                   readonly
                   @if(isset($oldHD->XVPohBillDays)) value="{{$oldHD->XVPohBillDays ?? ""}}" @endif
                   @if(isset($oldHD->XVGrhBillDays)) value="{{$oldHD->XVGrhBillDays ?? ""}}" @endif

                   id="XVPohBillDays">
        </div>
    </div>
</div>
<div class="form-group row mb-1 pb-0" style="display: none">
    <label class="col-md-4  col-xl-2 col-form-label">สถานที่จัดส่ง</label>
    <div class="col">
        <div class="input-group">
            <input type="text" class="form-control" name="XVPohDeliveryPlace"
                   readonly
                   @if(isset($oldHD->XVPohDeliveryPlace)) value="{{$oldHD->XVPohDeliveryPlace ?? "สำนักงานใหญ่"}}"
                   @endif
                   @if(isset($oldHD->XVGrhDeliveryPlace)) value="{{$oldHD->XVGrhDeliveryPlace  ?? "สำนักงานใหญ่"}}"
                   @endif
                   id="XVPohDeliveryPlace">
        </div>
    </div>
</div>
<div class="dropdown-divider"></div>

<div class="form-group row mb-1 pb-0" style="display: none">
    <label class="col-md-4  col-xl-2 col-form-label">ประเภทภาษี</label>
    <div class="col col-lg-4 mt-2">
        <div class="custom-control-inline pr-2">
            <input class="form-check-input" type="radio" name="XBPohTaxType"
                   onclick="return false;"
                   @if(isset($oldHD->XBPohTaxType))
                   @if($oldHD->XBPohTaxType == "1")
                   checked
                   @endif
                   @elseif(isset($oldHD->XBGrhTaxType))
                   @if($oldHD->XBGrhTaxType == "1")
                   checked
                   @endif
                   @endif
                   value="1" onclick="VatCase()">
            <label class="">ภาษีแยกนอก</label>
        </div>
        <div class=" custom-control-inline">
            <input
                onclick="return false;"
                @if(isset($oldHD->XBPohTaxType))
                @if($oldHD->XBPohTaxType == "0")
                checked
                @endif
                @elseif(isset($oldHD->XBGrhTaxType))
                @if($oldHD->XBGrhTaxType == "0")
                checked
                @endif
                @endif
                class="form-check-input" type="radio" name="XBPohTaxType"
                value="0" onclick="VatCase()">
            <label class="">ภาษีรวมใน</label>
        </div>
    </div>
</div>
<script src="{{asset('js/pages/GR/pdfpo.js')}}"></script>
