@extends('layouts.master')
@section('header')
    <link href="{{asset('css/gijgo.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{asset('css/select2.min.css')}}" rel="stylesheet"/>
    <link rel="stylesheet"
          href="{{asset('css/select2-bootstrap4.min.css')}}">
@endsection
@php
    $menuperm = Illuminate\Support\Facades\Session::get('menu_perm') ?? [];
@endphp
<style>
    div.sticky {
        position: sticky;
        top: 0;
        background-color: #ffffff;
        padding-top: 8px;
        z-index: 100;
    }

    form.noStyle {
        margin: 0;
    }

    .btn-circle.btn-sm {
        width: 30px;
        height: 30px;
        padding: 6px 0px;
        border-radius: 15px;
        font-size: 8px;
        text-align: center;
    }

    .form-control {
        display: inline-block !important;
    }

    tr:hover {
        background-color: #f5f5f5;
    }
</style>
@section('content')
    <form action="{{route('gi.updateStatus')}}" method="POST" style="margin: 0"
          onkeypress="return event.keyCode != 13;"
          id="updateForm"
          onsubmit="event.preventDefault(); return Swal_Ask('{{getDocStatusByCode(3)}}',this)">
        @csrf
        <div class="col-1 text-left">
            <input type="hidden" class="form-control" name="XVGihDocNo" value="{{$hd->XVGihDocNo}}" readonly>
            <input type="hidden" class="form-control" id="eventRequest" name="eventRequest" value="3" readonly>
            <input type="hidden" class="form-control" id="docStatus" name="docStatus" value="{{$DocStatus}}" readonly>
        </div>
    </form>
    <form action="{{route('gi.updateEmpty')}}" method="POST" id="Form_Submit"
          class="noStyle"
          onsubmit="return validateForm()">
        @csrf
        @method('PUT')
        <div class="card ">
            <div class="card-body">
                <div class="sticky">
                    <div class="row ">
                        <div class="col-3 ">
                            <h5>ฟอร์มแก้ไขข้อมูลใบเบิกวัสดุ</h5>
                        </div>
                        {{-- @if($DocStatus == "1")
                            <div class="col-1 text-left">
                                <button type="submit" class="btn btn-primary">บันทึก</button>
                            </div>
                            <div class="col-1 text-left">
                                <button type="button" class="btn btn-{{getCssDocStatusByCode(3)}}"
                                        id="btn_updateStatus"
                                        onclick="updateStatus(3,'{{getDocStatusByCode(3)}}')">{{getDocStatusByCode(3)}}</button>
                            </div>
                            <div class="col-1 text-left">
                                <button type="button" class="btn btn-{{getCssDocStatusByCode(5)}}"
                                        id="btn_cancle"
                                        onclick="updateStatus(5,'{{getDocStatusByCode(5)}}')">{{getDocStatusByCode(5)}}</button>
                            </div>
                        @endif
                        @if($DocStatus == "3")
                            <div class="col-1 text-left">
                                <a href="#" type="button" class="btn btn-info"
                                   onclick="renderPdf('{{route('gi.pdf',['docNo'=>$hd->XVGihDocNo])}}')"><i
                                        class="far fa-file-pdf"></i> PDF</a>
                                <input type="hidden" id="url" value="{{url('')}}">
                            </div>
                        @endif

                        <div class="col text-right">
                            <label for="" class="mr-2 fontsi">สถานะเอกสาร : {{getDocStatusByCode($DocStatus)}}</label>

                            <a href="{{route('gi.index')}}" class="btn btn-success"><i
                                    class="fas fa-long-arrow-alt-left fa-lg"></i> <span>กลับ</span></a>
                        </div> --}}
                     
                        @php
                            $routeBack= 'gi.index';
                        @endphp

                        @component('Components.HandleDocStatus',['routeBack'=> $routeBack,'DocStatus'=>$DocStatus])
                        <input type="hidden" id="isView" value="true" readonly>
                            <div class="col-1 text-left">
                                <a href="#" type="button" class="btn btn-info"
                                   onclick="renderPdf('{{route('gi.pdf',['docNo'=>$hd->XVGihDocNo])}}')"><i class="far fa-file-pdf"></i> PDF</a>
                                <input type="hidden" id="url" value="{{url('')}}">
                            </div>
                         @endcomponent

                    </div>
                    <hr>
                </div>
                <h5>ข้อมูลเอกสาร</h5>

                <div class="row border">

                    <div class="col border-right ">

                        @component('Gi.components.hd',['oldHD'=>$hd,'empty'=>true])
                        @endcomponent
                    </div>
                    <div class="col-4 border-right ">
                        @component('Gi.components.rmk',['XVGihDocRmk'=>$hd->XVGihDocRmk])
                        @endcomponent
                    </div>

                </div>
                <div class="row border">
                    <div class="col border-right ">
                        @component('Gi.components.dtMat',['oldDT'=>$dt])
                        @endcomponent
                    </div>
                </div>
            </div>
        </div>
        </div>
    </form>
    <input type="hidden" name="msg" value="{{session()->get('msg')}}">

@endsection
<script src="{{asset('js/helper.js')}}"></script>
<script src="{{asset('js/jquery-3.5.1.min.js')}}"></script>
<script src="{{asset('js/gijgo.min.js')}}" defer type="text/javascript"></script>
<script src="{{asset('js/select2.min.js')}}" defer></script>
<script src="{{asset('js/sweetalert.min.js')}}"></script>
<script src="{{asset('js/pages/Gi/formEmpty.js')}}"></script>

<script src="{{asset('js/ThbNumber.js')}}"></script>
<script src="{{ asset('js/pdfmake.js') }}"></script>
<script src="{{asset('js/pages/gi/pdf.js')}}"></script>
<script>
    async function Swal_Ask(text, form) {
        let resp = swal({
            title: `ยืนยันการ ${text} ?`,
            text: "หากยืนยันแล้วไม่สามารถเปลี่ยนแปลงได้",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
        let isOk = await resp
        if (isOk) form.submit();
    }

    async function updateStatus(statusCode, text) {
        const ApproveForm = document.getElementById("updateForm");
        const eventRequest = document.getElementById("eventRequest");

        const XIOrdBalance = getArrayInput('XIOrdBalance[]');
        const XIGidQty = getArrayInput('XIGidQty[]');
        let state = true;
        for (let i = 0; i < XIOrdBalance.length; i++) {
            const CurrentBlanace = XIOrdBalance[i];
            const CurrentGidQty = XIGidQty[i];
            if (+CurrentGidQty > +CurrentBlanace) {
                state = false;
                break;
            }
        }
        if (state) {
            let resp = swal({
                title: `ยืนยันการ ${text} ?`,
                text: "หากยืนยันแล้วไม่สามารถเปลี่ยนแปลงได้",
                icon: "warning",
                buttons: true,
                dangerMode: true,
            })
            let isOk = await resp
            if (isOk) {
                eventRequest.value = statusCode
                ApproveForm.submit()
            }
        } else {
            let resp = swal({
                title: "จำนวนคงเหลือ น้อยกว่าจำนวนที่เบิก",
                text: "ยืนยันหรือไม่ ?",
                icon: "warning",
                buttons: true,
                dangerMode: true,
            })
            let isOk = await resp
            if (!!isOk) {
                let resp = swal({
                    title: `ยืนยันการ ${text} ?`,
                    text: "หากยืนยันแล้วไม่สามารถเปลี่ยนแปลงได้",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                })
                let isOk = await resp
                if (isOk) {
                    eventRequest.value = statusCode
                    ApproveForm.submit()
                }
            }
        }
    }

    $(document).ready(function () {
        if ($('input[name="msg"]').val() == 'IsNotBalanced') {
            swal("เกิดข้อผิดพลาด", "กรุณาทำรายการยอดยกมาวัสดุของเดือนที่แล้วก่อนทำการอนุมัติ", "warning");
        }
        var oldList = document.getElementsByClassName("dtItems")
        let oldArr = [];
        for (let i = 0; i < oldList.length; i++) {
            oldArr.push(oldList[i].id)
        }
        TriggerChange(oldArr)

        const FarbicItem = document.getElementById('SelectPureMaterial').value;
        TriggerFarbic(FarbicItem);
    })
</script>

