@extends('layouts.master')
@section('header')
    <link href="{{ asset('css/gijgo.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('css/select2.min.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('css/select2-bootstrap4.min.css') }}">

@endsection
@php
    use Illuminate\Support\Facades\DB;
    $customer = DB::table('tmstmcustomer')
        ->orderBy('XVCstCode', 'asc')
        ->get();
@endphp
@section('content')

    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <div class="card">
        <div class="card-body">
            <div class="row ">
                <div class="col-6">
                    <h5 style="font-weight: bold;">รายงานการเบิกจ่ายสินค้าแยกตามลูกค้า</h5>
                </div>
                <div class="col-6 text-right">
                    <a href="{{route('report.dashboard.index')}}" class="btn btn-danger ">ย้อนกลับ</a>
                </div>
            </div>
            <hr>
            <div class="card-body">
                <div class="row mt-1 ">
                    <div class="card " style="max-width: 650px;min-width: 650px;margin: auto;
                        padding: 10px;">
                        <div class="col-12 text-center mt-2">
                            <h6 style="font-weight: bold ">เงื่อนไขในการเลือก</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12 ">
                                    <h6 style="font-weight: bold">วันที่</h6>
                                    <input type="checkbox" class="mr-2" id="AllDate" onclick="AllDate()" checked>ทั้งหมด
                                    <div class="row mt-3">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3 pr-2 text-right">
                                            ตั้งแต่วันที่</p>
                                        <input class="form-control" type="date" value="" name="DateStart" id="DateStart"
                                               style="max-width: 180px;min-width: 180px;">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3  pr-2 text-right">
                                            ถึงวันที่</p>
                                        <input class="form-control" type="date" value="" name="DateEnd" id="DateEnd"
                                               style="max-width: 180px;min-width: 180px;">
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-4">
                                <div class="col-12">
                                    <h6 style="font-weight: bold">ลูกค้า</h6>
                                    <input type="checkbox" class="mr-2" id="AllCst" onclick="AllCst()" checked>ทั้งหมด
                                    <div class="row mt-2">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3  pr-2 text-right">จาก</p>
                                        <select class="form-control" style="max-width: 480px;min-width: 480px;"
                                                id="SelectCustomerStart" @if (isset($isMultiple) && $isMultiple == true) multiple @endif @if (isset($isRequired) && $isRequired == true)
                                                required @endif
                                                @if (isset($isReadOnly) && $isReadOnly == true)
                                                readonly @endif
                                                name="XVCstCode">
                                            <option></option>
                                            @foreach ($customer as $key => $item)
                                                <option data-raw="{{ json_encode($item) }}" @if (isset($oldValue) && $oldValue == $item->XVCstCode) selected @endif value="{{ $item->XVCstCode }}">
                                                    {{ $item->XVCstCode }} {{ $item->XVCstName }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="row mt-2">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3  pr-2 text-right">ถึง</p>

                                        <select class="form-control" style="max-width: 480px;min-width: 480px;"
                                                id="SelectCustomerEnd" @if (isset($isMultiple) && $isMultiple == true) multiple @endif @if (isset($isRequired) && $isRequired == true)
                                                required @endif
                                                @if (isset($isReadOnly) && $isReadOnly == true)
                                                readonly @endif
                                                name="XVCstCode">
                                            <option></option>
                                            @foreach ($customer as $key => $item)
                                                <option data-raw="{{ json_encode($item) }}" @if (isset($oldValue) && $oldValue == $item->XVCstCode) selected @endif value="{{ $item->XVCstCode }}">
                                                    {{ $item->XVCstCode }} {{ $item->XVCstName }} </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="row mt-1">

                            <div class="col-8 text-right">
                                <button class="btn btn-info bottom " style="vertical-align: bottom;" onclick="datareport()">
                                    export pdf</button>
                                <button class="btn btn-success bottom " style="vertical-align: bottom;" onclick="datareportexcel()">export
                                    excel</button>
                            </div>
                        </div>
                        <div style=" visibility: hidden;" id="a" >
                            <table id="example" >
                            </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
    <input type="hidden" id="CstEnd" >
    <input type="hidden" id="CstStart" >
    <script src="{{ asset('js/pages/excel/table2excel.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            AllCst();
            AllDate();
            // datareport();
            const CstStart = $('#SelectCustomerStart').select2({
                placeholder: "เลือกลูกค้า",
                theme: 'bootstrap4',
            });
            const CstEnd = $('#SelectCustomerEnd').select2({
                placeholder: "เลือกลูกค้า",
                theme: 'bootstrap4',
            });
            Date.prototype.toDateInputValue = (function() {
                var local = new Date(this);
                local.setMinutes(this.getMinutes() - this.getTimezoneOffset());
                return local.toJSON().slice(0, 10);
            });
            CstEnd.on('select2:select', function (e) {
                var {id, text} = (e.params.data);
                $("#CstEnd").val(text.trim());
            });
            CstStart.on('select2:select', function (e) {
                var {id, text} = (e.params.data);
                $("#CstStart").val(text.trim());
            });

            document.getElementById('DateStart').value = new Date().toDateInputValue();
            document.getElementById('DateEnd').value = new Date().toDateInputValue();



        })
    </script>

    <script>
           function excel() 
        {
            $('#example').table2excel({
                        exclude: ".noExport",
                        name: "Data",
                        filename: "403 รายงานการเบิกจ่ายสินค้าแยกตามลูกค้า",
                        title:"kanin",
                        topic:"..."
                    });
        }
        function AllCst() {
            var checkBox = document.getElementById("AllCst");
            if (checkBox.checked == true) {
                document.getElementById('SelectCustomerStart').disabled = true;
                document.getElementById('SelectCustomerEnd').disabled = true;
            } else {
                document.getElementById('SelectCustomerStart').disabled = false;
                document.getElementById('SelectCustomerEnd').disabled = false;
            }
        }

        function AllDate() {
            var checkBox = document.getElementById("AllDate");
            if (checkBox.checked == true) {
                document.getElementById('DateStart').disabled = true;
                document.getElementById('DateEnd').disabled = true;
            } else {
                document.getElementById('DateStart').disabled = false;
                document.getElementById('DateEnd').disabled = false;
            }
        }

        function datareport() {
            var dataSet = [];
            let _token = $('meta[name="csrf-token"]').attr('content');
            const DateStart = document.getElementById('DateStart').value;
            const DateEnd = document.getElementById('DateEnd').value;
            const XVSplCodeStart = document.getElementById('SelectCustomerStart').value;
            const XVSplCodeEnd = document.getElementById('SelectCustomerEnd').value;
            const isAllTime = document.getElementById('AllDate').checked;
            const isAllSpl = document.getElementById('AllCst').checked;
            //ShowValue
            const CstStart = document.getElementById('CstStart').value;
            const CstEnd = document.getElementById('CstEnd').value;

            //End Show Value
            let JsonFilter = {
                DateStart,
                DateEnd,
                XVSplCodeStart : CstStart,
                XVSplCodeEnd : CstEnd,
                isAllTime,
                isAllSpl,
            }
            $.ajax({
                url: '{{ route('report.403.data') }}',
                type: "POST",
                data: {
                    _token: _token,
                    DateStart,
                    DateEnd,
                    XVSplCodeStart,
                    XVSplCodeEnd,
                    isAllTime,
                    isAllSpl,
                },
                success: function(result) {
                    console.log(result);
                    renderPdf(result,JsonFilter);
                }
            });
        }
        function datareportexcel() {
            var dataSet = [];
            let _token = $('meta[name="csrf-token"]').attr('content');
            const DateStart = document.getElementById('DateStart').value;
            const DateEnd = document.getElementById('DateEnd').value;
            const XVSplCodeStart = document.getElementById('SelectCustomerStart').value;
            const XVSplCodeEnd = document.getElementById('SelectCustomerEnd').value;
            const isAllTime = document.getElementById('AllDate').checked;
            const isAllSpl = document.getElementById('AllCst').checked;
            //ShowValue
            const CstStart = document.getElementById('CstStart').value;
            const CstEnd = document.getElementById('CstEnd').value;

            //End Show Value
            let JsonFilter = {
                DateStart,
                DateEnd,
                XVSplCodeStart : CstStart,
                XVSplCodeEnd : CstEnd,
                isAllTime,
                isAllSpl,
            }
            $.ajax({
                url: '{{ route('report.403.dataexcel') }}',
                type: "POST",
                data: {
                    _token: _token,
                    DateStart,
                    DateEnd,
                    XVSplCodeStart,
                    XVSplCodeEnd,
                    isAllTime,
                    isAllSpl,
                },
                success: function(result) {
                    console.log(result);
                    for (let index = 0; index < result.length; index++) {  
                        var row=[result[index].XVCstCode,
                                result[index].XVCstName,
                                result[index].XDFihDocDate,
                                result[index].XVFihDocNo,
                                result[index].xvpdtcode,
                                result[index].XVPszName,
                                result[index].XIFidQty,
                            ];
                            dataSet.push(row);
                    }
                    $('table tbody').remove()
                    $('#example').DataTable({
                        "destroy": true,
                        "data": dataSet,
                        paging: false,
                        "columns": [
                           
                            {
                                "title": "รหัสลูกค้า",
                               
                            },
                            {   "title": "ชื่อลูกค้า",
                                
                            },
                            {
                                "title": "วันที่",
                                
                            },
                            {   "title": "เลขที่ใบเบิกสินค้า",
                                
                            },

                             {   "title": "สินค้า",
                               
                            },
                            {   "title": "ขนาด",
                                
                            },
                            {   "title": "จำนวน",
                               
                            },
                            


                        ]
                    });
                        
                    if(isAllTime)
                    {
                        
                        start = "ทั้งหมด";
                         end= "ทั้งหมด";
                    }
                    else
                    {
                        start = convertDateToLocale(DateStart);
                        end= convertDateToLocale(DateEnd);
                    }
                    if(isAllSpl)
                    {
                        
                        splstart = "ทั้งหมด";
                         splend= "ทั้งหมด";
                    }
                    else
                    {
                        splstart = XVSplCodeStart;
                        splend= XVSplCodeEnd;
                    }
                    var htmltb = document.getElementById('example').innerHTML;
                    document.getElementById('example').innerHTML =
                    "<thead>"+
                    "<tr><th colspan='4'>403 รายงานการเบิกจ่ายสินค้าแยกตามลูกค้า <br> จากวันที่ "+start+" ถึงวันที่ "+end+ "<br> จากลูกค้า "+splstart+" ถึง "+splend+"</th></tr>"+
                    " </thead>"+htmltb;
                    excel();
                    $('table tbody').remove()
                    document.getElementById('a').innerHTML =" <table id='example' ></table>"
                   
                }
            });
        }

    </script>
@endsection
<script src="{{ asset('js/pages/report/R403.js') }}"></script>
<script src="{{ asset('js/jquery-3.5.1.min.js') }}"></script>
<script src="{{ asset('js/gijgo.min.js') }}" defer type="text/javascript"></script>
<script src="{{ asset('js/select2.min.js') }}" defer></script>
<script src="{{ asset('js/sweetalert.min.js') }}"></script>
<script src="{{ asset('js/pdfmake.js') }}"></script>
