@extends('layouts.master')
@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col">
                    <h5 style="font-weight: bold">CST PO</h5>
                </div>
                {{-- <div class="col text-right">
                    <a href="{{route('form_add_customer')}}" class="btn btn-success"><i class="fas fa-plus-square"></i>
                        เพิ่มข้อมูล</a>
                </div> --}}
            </div>
            <hr>

            <div class="row mt-5"  style="max-height: 70vh;overflow-y: scroll;">
                <div class="col-12">
                    <table id="tb_customer" class="table table-striped table-sm" style="width:100%">
                        <thead style="">
                        <tr>
                            <td style="width: 10%;">CST ID</td>
                            <td style="width: 10%;">วันที่รับ</td>
                            <td style="width: 10%;">วันที่ส่ง</td>
                            <td style="width: 10%;">Po Number</td>
                            <td style="width:20%;">Item Number</td>
                            <td style="width:10%;">Item Name</td>
                            <td style="width:20%;">Description</td>
                            
                            <td style="width:10%;text-align:center;">PDF</td>
                        </tr>
                        </thead>
                        <tbody >
                        @foreach ($HD as $cst)
                            <tr class="">
                                <td >{{$cst->XVCusId}}</td>
                                
                                <td >{{$cst->XDDateIn}}</td>
                                <td >{{$cst->XDDateSent}}</td>
                                <td >{{$cst->XVOrderMItemNo}}</td>
                                <td >{{$cst->XVStyle}}</td>
                                <td>{{$cst->XVOrderIn}}</td>
                                <td >{{$cst->XVSta}}</td>
                                
                                <td style="text-align:center;">  <a href="#" onclick="renderPdf('{{route('CstPo.getOld',['docNo'=>$cst->XVOrderMItemNo])}}')" class="btn-sm btn-info">
                                    <i class="far fa-file-pdf"></i></a>
                               
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <input type="hidden" name="msg" value="{{session()->get('msg')}}">
@endsection
<style>
    #tb_customer thead {
        font-weight: bold;
        text-align: left;
    }

    #tb_customer tbody {
        font-size: 14px;
        text-align: left;
        font-weight: 400;
    }

    #tb_customer tbody tr {
        cursor: pointer;
    }

    #tb_customer tbody tr:hover {
        cursor: pointer;
        background-color: azure;
    }

    #tb_customer tbody td {
        vertical-align: middle;
    }

    #tb_customer a {
        padding: 0.2cm 0.2cm 0.2cm 0.2cm;
        color: white;
    }

    #tb_customer i {
        text-align: center
    }

    #tb_customer_filter {
        margin-bottom: 1cm;
    }
</style>
<script src="{{asset('js/jquery-3.5.1.min.js')}}"></script>
<script src="{{asset('js/sweetalert.min.js')}}"></script>
<script src="{{ asset('js/app.js') }}"></script>
<script src="{{asset('js/pages/CstPo/pdf.js')}}"></script>
<script src="{{asset('js/ThbNumber.js')}}"></script>
<script src="{{ asset('js/pdfmake.js') }}"></script>
<script src="{{ asset('js/BAHTTEXT.js') }}"></script>
<script>
    $(document).ready(function () {
        if ($('input[name="msg"]').val() == 'success') {
            swal("บันทึกข้อมูลเรียบร้อย", "คลิก ตกลง", "success");
        }
        if ($('input[name="msg"]').val() == 'busy') {
            swal("ไม่สามารถลบได้", "ข้อมูลที่เลือกถูกใช้ในข้อมูลอื่น", "warning");
        }
        if ($('input[name="msg"]').val() == 'Duplicate') {
            swal("ไม่สามารถเพิ่ม / แก้ไขข้อมูลได้", "ข้อมูลที่เพิ่ม / แก้ไขมีชื่อลูกค้านี้แล้วภายในระบบ", "warning");
        }
        $('#tb_customer').DataTable({
            "order": [],
            "language": {
                "search": "ค้นหา"
            }
        });
    });

    function del(id) {
        swal({
            title: "คุณต้องลบข้อมูลลูกค้าหรือไม่",
            // text: "Once deleted, you will not be able to recover this imaginary file!",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
            .then((willDelete) => {
                if (willDelete == true) {
                    location.href = 'del_customer/' + id + '';
                } else {
                    console.log('no')
                }
            })
    }
</script>
