<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class MasterDesignController extends Controller
{
    private  $TableName = 'tmstmdesign';
    private  $TableNameCol = 'tmstmdesign.';
    public function index()
    {
        $HD = DB::table('tmstmdesign')
            ->leftjoin('tmstmmaterial', 'tmstmdesign.xvmatcode', 'tmstmmaterial.xvmatcode')
            ->orderBy('XVDsCode', 'DESC')
            ->get();
        $data = [
            'HD' => $HD,
        ];
        return view("Design.index", $data);
    }

    public function FormEdit($xvpdtcode)
    {
        $hd = DB::table('tmstmdesign')->where('XVDsCode', '=', $xvpdtcode)->first();
        return view('Design.frm_edit', [
            'hd' => $hd
        ]);
    }
    public function GetAjax($xvpdtcode)
    {
        $hd = DB::table('tmstmdesign')->where('XVDsCode', '=', $xvpdtcode)->first();
         return response()->json($hd);
    }

    public function FormInsert()
    {
        return view('Design.frm_add');
    }


    
    public function Store(Request $request)
    {
        if (isset($request->ImgResize)) {
            $imageName = time() . '.' . $request->ImgResize->extension();
        } else {
            $imageName = "not-found.jpg";
        }
        try {
          
            DB::beginTransaction();
            $docNo = GeneratePrimaryKeyDate('tmstmdesign', 'XVDsCode', 'DS',2);
            DB::table('tmstmdesign')->insert([
                'XVDsCode' => $docNo,
                'XVDsName' => $request->XVDsName,
                'XVDsImg' => "images/" . $imageName,
                'XFDsCost' => $request->XFDsCost,
                'XFDsPrice' => $request->XFDsPrice,
                'XVDsColor' => $request->XVDsColor,
                'XISeasonCode' => $request->SelectSeason,
                'XIForCode' => $request->SelectForUse,
                'XIGenerateCode' => $request->SelectGenerate,
                'XIShapeCode' => $request->SelectShape,
                'XVMatCode' => $request->SelectPureMaterial, // meaing Farbic Material
//                new Required
                'XVDsPatternNo' => $request->XVDsPatternNo,
                'XVDsClothFace' => $request->XVDsClothFace,
                'XVDsCrotchFabric' => $request->XVDsCrotchFabric,
                'XVDsFarbicA' => $request->XVDsFarbicA,
                'XVDsFarbicB' => $request->XVDsFarbicB,
                'XVDsCmtDetail' => $request->XVDsCmtDetail,
                'XVDsCmtDetailMore' => $request->XVDsCmtDetailMore,
                'XVDsCmtZipSize' => $request->XVDsCmtZipSize,
                'XVDsCmtButton' => $request->XVDsCmtButton,
                'XVDsCmtSecretBag' => $request->XVDsCmtSecretBag,
                'XVDsCmtBackPocket' => $request->XVDsCmtBackPocket,
                'XVDsCmtEarSize' => $request->XVDsCmtEarSize,
                'XVDsCmtSewing' => $request->XVDsCmtSewing,
                'XVDsCmtTwill' => $request->XVDsCmtTwill,
                'XVDsCmtTagging' => $request->XVDsCmtTagging,
                'XVDsCmtTung' => $request->XVDsCmtTung,
                'XVPohDocRmk' => $request->XVPohDocRmk,
                'XVDsCmtSpecial' => $request->XVDsCmtSpecial,
            ]);

            if (isset($request->ImgResize)) {
                $request->ImgResize->move(public_path('images'), $imageName);
            }

            DB::commit();
            return redirect()->route('design.index');
//            return redirect()->route('mat.edit',['XVPohDocNo'=>$docNo])->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }

    }


    public function Update(Request $request)
    {
        
        try {
            $isUploadNew = false;
            if (isset($request->ImgResize)) {
                $isUploadNew = true;
                $imageName =  "images/".time() . '.' . $request->ImgResize->extension();
            } else {
                $imageName = $request->oldImg;
               // dd($imageName);
            }
            DB::beginTransaction();
            $docNo = $request->XVDsCode;
            DB::table('tmstmdesign')
                ->where('XVDsCode', '=', $docNo)
                ->update([
                    'XVDsName' => $request->XVDsName,
                'XVDsImg' =>  $imageName,
                'XFDsCost' => $request->XFDsCost,
                'XFDsPrice' => $request->XFDsPrice,
                'XVDsColor' => $request->XVDsColor,
                'XISeasonCode' => $request->SelectSeason,
                'XIForCode' => $request->SelectForUse,
                'XIGenerateCode' => $request->SelectGenerate,
                'XIShapeCode' => $request->SelectShape,
                'XVMatCode' => $request->SelectPureMaterial, // meaing Farbic Material
//                new Required
                'XVDsPatternNo' => $request->XVDsPatternNo,
                'XVDsClothFace' => $request->XVDsClothFace,
                'XVDsCrotchFabric' => $request->XVDsCrotchFabric,
                'XVDsFarbicA' => $request->XVDsFarbicA,
                'XVDsFarbicB' => $request->XVDsFarbicB,
                'XVDsCmtDetail' => $request->XVDsCmtDetail,
                'XVDsCmtDetailMore' => $request->XVDsCmtDetailMore,
                'XVDsCmtZipSize' => $request->XVDsCmtZipSize,
                'XVDsCmtButton' => $request->XVDsCmtButton,
                'XVDsCmtSecretBag' => $request->XVDsCmtSecretBag,
                'XVDsCmtBackPocket' => $request->XVDsCmtBackPocket,
                'XVDsCmtEarSize' => $request->XVDsCmtEarSize,
                'XVDsCmtSewing' => $request->XVDsCmtSewing,
                'XVDsCmtTwill' => $request->XVDsCmtTwill,
                'XVDsCmtTagging' => $request->XVDsCmtTagging,
                'XVDsCmtTung' => $request->XVDsCmtTung,
                'XVPohDocRmk' => $request->XVPohDocRmk,
                'XVDsCmtSpecial' => $request->XVDsCmtSpecial,
                ]);
            if ($isUploadNew) {
              
                $request->ImgResize->move(public_path('images'), $imageName);
//                if (File::exists(public_path($request->oldImg))) {
//                    File::delete(public_path($request->oldImg));
//                }
            }
            DB::commit();
            return redirect()->back();
//            return redirect()->route('mat.index');
//            return redirect()->route('mat.edit',['XVPohDocNo'=>$docNo])->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    
}
