<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class Report403Controller extends Controller
{
    //
    public function index()
    {
        return view('Report/index403');
    }
    public function data(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $XVSplCodeStart = $request->input('XVSplCodeStart');
        $XVSplCodeEnd = $request->input('XVSplCodeEnd');
        $isAllSpl = $request->input("isAllSpl") === 'true' ? true : false;
        //        Section Data

        $customer = DB::table('tmstmcustomer');
        $customer = condition_LCR($customer, 'XVCstCode', $isAllSpl, $XVSplCodeStart, $XVSplCodeEnd);
        foreach ($customer as $item) {
            $OrderHD = DB::table('tdoctfihd')
                ->where('XVFihDocStatus', '=', '3')
                ->where('XVCstCode', '=', $item->XVCstCode);
            $OrderHD = condition_LCR($OrderHD, 'XDFihDocDate', $isAllTime, $DateStart, $DateEnd);
            if (count($OrderHD) > 0) {
                $item->OrderHD = $OrderHD;
                foreach ($item->OrderHD as $itemSecond) {
                    $OrderDT = DB::table('tdoctfidt')
                        ->where('XVFihDocNo', '=', $itemSecond->XVFihDocNo);
                    $itemSecond->OrderDT = $OrderDT
                        ->leftJoin('tmstmproduct', 'tdoctfidt.xvpdtcode', '=', 'tmstmproduct.xvpdtcode')
                        ->get();;
                    $SumQty = $OrderDT
                        ->select(DB::raw('SUM(XIFidQty) as SumQty'))
                        ->first();
                    $itemSecond->SumQty = $SumQty->SumQty;
                }
            } else {
                $item->OrderHD = [];
            }
        }
        return response()->json($customer);
    }
    public function datexcel(Request $request)
    {
        //        Section Data
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $XVSplCodeStart = $request->input('XVSplCodeStart');
        $XVSplCodeEnd = $request->input('XVSplCodeEnd');
        $isAllSpl = $request->input("isAllSpl") === 'true' ? true : false;
        //        Section Data

        $customer = DB::table('tdoctfidt');
        $customer ->Join('tdoctfihd', 'tdoctfihd.XVFihDocNo', '=', 'tdoctfidt.XVFihDocNo')
                 ->where('XVFihDocStatus', '=', '3')
                 ->Join('tmstmcustomer', 'tdoctfihd.XVCstCode', '=', 'tmstmcustomer.XVCstCode');
                 $customer = condition_LCRVOutide($customer, 'tdoctfihd.XVCstCode', $isAllSpl, $XVSplCodeStart, $XVSplCodeEnd);
                 $customer = condition_LCR($customer, 'XDFihDocDate', $isAllTime, $DateStart, $DateEnd);
        return response()->json($customer);
    }
}
