<?php

namespace App\Http\Controllers\Report;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
class Report405Controller extends Controller
{
    //
    public function index()
    {
        return view('Report/index405');
    }
    public function data(Request $request)
    {
        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $MstItemStart = $request->input('MstItemStart');
        $MstItemEnd = $request->input('MstItemEnd');
        $isAllMst = $request->input("isAllMst") === 'true' ? true : false;
        $material = DB::table('tmstmproduct');
        $material = condition_LCR($material, 'xvpdtcode', $isAllMst, $MstItemStart, $MstItemEnd);
        foreach ($material as $item) {
            $OrderHD =DB::table('tstktmatstockcardproduct')
                ->orderBy('xvpszname', 'asc')
                ->orderBy('id', 'asc')
                ->where('xvpdtcode', '=', $item->xvpdtcode);
             $OrderHD = condition_LCR($OrderHD, 'xdstkdate', $isAllTime, $DateStart, $DateEnd);
            if (count($OrderHD) > 0) {
                $item->OrderHD = $OrderHD;
            } else {
                $item->OrderHD = [];
            }
        }
        return response()->json($material);
    }
    public function datexcel(Request $request)
    {

        $DateStart = $request->input('DateStart');
        $DateEnd = $request->input('DateEnd');
        $isAllTime = $request->input("isAllTime") === 'true' ? true : false;
        $MstItemStart = $request->input('MstItemStart');
        $MstItemEnd = $request->input('MstItemEnd');
        $isAllMst = $request->input("isAllMst") === 'true' ? true : false;
        //        Section DataR
        $PDT       =  DB::table('tstktmatstockcardproduct')
                     ->Join('tmstmproduct', 'tstktmatstockcardproduct.xvpdtcode', '=', 'tmstmproduct.xvpdtcode')
                     ->orderBy('xvpszname', 'asc');
        $PDT          ->orderBy('tstktmatstockcardproduct.id', 'asc');
        $PDT = condition_LCRVOutide($PDT, 'tstktmatstockcardproduct.xvpdtcode', $isAllMst, $MstItemStart, $MstItemEnd);
        $PDT = condition_LCR($PDT, 'xdstkdate', $isAllTime, $DateStart, $DateEnd);
        return response()->json($PDT);
    }
}
