$(document).ready(function () {
    let index = 0;
    $('#datepicker').datepicker({
        uiLibrary: 'bootstrap4',
        format: 'dd-mm-yyyy'
    });
    var SelectMasterItemsSize = $('#SelectMasterItemsSize').select2({
        placeholder: "เลือกสินค้า",
        theme: 'bootstrap4',
    });
    $('#SelectMasterItemsSize').on('select2:select', function (e) {
        var {id,text} = (e.params.data);
        let [xvpdtcode,size] = id.split("_");
        createProduct(xvpdtcode,text,size,index)
        index= index+1;
    });
    $('#SelectMasterItemsSize').on('select2:unselect', function (e) {
        var data = (e.params.data);
        document.getElementById(data.id).remove()
    });
    window.TriggerChange = function(oldArr){
        SelectMasterItemsSize.val(oldArr).trigger("change");
    }
})
async function createProduct(id,text,sizeType,index) {
    // let sizeOption = renderOption(sizeType,'XVPszName','XVPszName','xvpdtcode')
    let BomDefault = await getBom(id,sizeType)

    let parentID = `${id}_${sizeType}`
    let childID = `group-of-rows-${parentID}`
    let childRow = renderChildRow(BomDefault.bom,index)
    let str = text.replace(/ /g, '');
    str = replaceQuotesText(str);
    let txt = str.split(":");
    const Control = document.getElementById("Control")
    Control.insertAdjacentHTML('beforeend',
                    `<tr id="${parentID}" class="dtItems tw-hover:" onclick="handleChild('${childID}')" style="cursor: pointer">
                                    <th scope="row">${txt[0]}</th>
                                    <th scope="row">${txt[1]}</th>
                                    <th >
                                    ${sizeType}
                                    </th>
                                    <td>
                                        <input type="text" class="form-control text-right" name="XIOrdQty[${index}][]"
                                        required
                                        onkeypress='return textNumber(event)' value="1"/>
                                    </td>

                                    <td class="text-center">
                                        <button type="button" class="btn btn-danger btn-circle btn-sm" onclick="removeRow('${parentID}','${childID}')">X</button>
                                    </td>
                                    <input type="hidden" name="xvpdtcode[${index}][]" value="${id}">
                                </tr>
                                <tr id="${childID}"  style="display: none">
                                    <td colspan="4">
                                        <table class="table table-bordered ">
                                            <thead>
                                            <tr>
                                                <th scope="col" width="10%">รหัส</th>
                                                <th scope="col">วัสดุ</th>
                                                <th scope="col" width="10%">จำนวนต่อหน่วย</th>
                                                <th scope="col" width="10%">หน่วยนับ</th>
                                            </tr>
                                            </thead>
                                            ${childRow}
                                        </table>
                                    </td>
                                </tr>
`)
}
function handleChild(childID){
    let child = document.getElementById(childID);
    if(child.style.display ==="none"){
        child.style.display = ""
    }else{
        child.style.display = "none"
    }
}
function renderChildRow(arrBom,index){
    let arr = "";
    for(let i= 0 ; i < arrBom.length;i++){
        console.log(arrBom[i])
        arr+=`<tr class="table-warning">
                                    <input type="hidden" name="xvmatcode[${index}][]" value="${arrBom[i].xvmatcode}">
                                    <input type="hidden" name="xvuntcode[${index}][]" value="${arrBom[i].xvuntcode}">

                                        <td>${arrBom[i].xvmatcode} </td>
                                        <td>${arrBom[i].xvmatname}</td>
                                        <td>
                                            <input type="text" class="form-control text-right" name="XIBomQty[${index}][]"
                                            required
                                            onkeypress='return textNumber(event)'  min="1" value="${arrBom[i].XIBomQty}"/>
                                        </td>
                                        <td>${arrBom[i].xvuntname}</td>
                                    </tr>`
    }
    return arr;
}
async function getBom(xvpdtcode,XVPszName){
    const AppUrl = document.getElementById('urlGlobal').value;
    const response = await  fetch(`${AppUrl}/bomSize/recepie/${xvpdtcode}/${XVPszName}`)
    return response.json();
}

function removeRow(id,childID){
    document.getElementById(id).remove();
    document.getElementById(childID).remove();
    updateCurrentDT()
}
function updateCurrentDT(){
    var oldList = document.getElementsByClassName("dtItems")
    let oldArr = [];
    for(let i = 0 ; i < oldList.length; i++){
        oldArr.push(oldList[i].id)
    }
    TriggerChange(oldArr)
}
function validateForm() {
    // const Customer = document.getElementById('SelectSupplier').value
    // if (Customer.trim().length > 0) {
    //     const input = getArrayInput('XIOrdQty[]');
    //     const itemFillter = input.filter((item) => item.trim().length === 0)
    //     if (itemFillter.length > 0) {
    //         swal('กรุณากรอกจำนวน', "กรุณากรอกจำนวนของวัตถุดิบ", "warning")
    //     } else {
    //         if(input.length>0){
    //             return true
    //         }else{
    //             swal('กรุณาเลือกสินค้า', "กรุณาเลือกสินค้าอย่างน้อย 1 ชนิด", "warning")
    //         }
    //     }
    //     return false
    // } else {
    //     swal('กรุณาเลือกลูกค้า', "กรุณาเลือกลูกค้า", "warning")
    // }
    // return false
    return true;
}
function getArrayInput(NameElement) {
    var input = document.getElementsByName(NameElement);
    let arr = []
    for (var i = 0; i < input.length; i++) {
        arr.push(input[i].value)
    }
    return arr;
}
