<div class="form-row mt-3 mb-1 pb-0" style="display: none">
    <div class="col-12">
        <label for="">เลือกสินค้า</label>
        @component('Components.Material')
        @endcomponent
    </div>
</div>

<div class="dropdown-divider "></div>
<div class="">
    <table class="table table-bordered table-sm">
        <thead>
        <tr>
            <th scope="col" width="10%">รหัส</th>
            <th scope="col">ชื่อรายการวัสดุ</th>
            <th scope="col" width="10%">หน่วย</th>
            <th scope="col" width="10%">จำนวนสั่งซื้อ</th>
            <th scope="col" width="10%">จำนวนที่รับเข้า</th>
            <th scope="col" width="10%">ราคา/หน่วย</th>
            {{--            <th scope="col" width="10%">ส่วนลด</th>--}}
            <th scope="col" width="10%">รวม</th>
        </tr>
        </thead>
        <tbody id="Control">
        @foreach($oldDT ?? [] as $item)
            @php
                $Material_Unit = DB::table('tmstmmat_unit')
                    ->where('xvmatcode','=',$item->xvmatcode)
                    ->leftjoin('tmstmunit', 'tmstmunit.xvuntcode', 'tmstmmat_unit.xvuntcode')
                    ->get()->toArray();
            @endphp
            <tr id="{{$item->xvmatcode}}" class="dtItems">
                <th scope="row">{{$item->xvmatcode}}</th>
                <th scope="row">
                    @if(isset($item->XVPodName))
                        {{$item->XVPodName}}
                    @elseif(isset($item->XVGrdName))
                        {{$item->XVGrdName}}
                    @endif
                </th>
                <th>
                    <select class="form-control" name="XVMatUnit_Name[]" readonly>
                        @foreach($Material_Unit as $matUnit)
                            <option value="{{$matUnit->xvuntcode}}"
                                    @if($item->xvuntcode == $matUnit->xvuntcode) selected @endif>{{$matUnit->xvuntname}}</option>
                        @endforeach
                    </select>
                </th>
                <td>
                    <input type="text" class="form-control text-right" name="XIGrdQtyPo[]"
                           readonly
                           value="{{$item->XIGrdQtyPo ?? $item->XIPodQty}}"
                           onkeypress='return isNumberKeyNoDot(event)'
                           onchange="RowValChange('{{$item->xvmatcode}}')" min="1"/>
                </td>
                <td>
                    <input type="text" class="form-control text-right" name="XIPodQty[]"
                           value="{{$item->XIGrdQty ?? $item->XIPodQty}}"
                           onkeypress='return isNumberKeyNoDot(event)'
                           onchange="RowValChange('{{$item->xvmatcode}}')" min="1"/>

                </td>
                <td>
                    <input type="text" class="form-control text-right" name="XFPodUnitCost[]"
                           readonly

                           @if(isset($item->XFPodUnitCost)) value="{{number_format($item->XFPodUnitCost,2,'.','')}}" @endif
                           @if(isset($item->XFGrdUnitCost)) value="{{number_format($item->XFGrdUnitCost,2,'.','')}}" @endif
                           onkeypress='return isNumberKey(event)'
                           onchange="RowValChange('{{$item->xvmatcode}}')" min="1"/>
                </td>
                <td style="display: none;">
                    <input type="text" class="form-control text-right" name="XFPodDiscount[]"
                           readonly
                           @if(isset($item->XFPodDiscount)) value="{{number_format($item->XFPodDiscount,2,'.','')}}" @endif
                           @if(isset($item->XFGrdDiscount)) value="{{number_format($item->XFGrdDiscount,2,'.','')}}" @endif

                           onkeypress='return isNumberKey(event)'
                           onchange="RowValChange('{{$item->xvmatcode}}')" value="0" min="0"/>
                </td>
                <td id="Child_Display" class="text-right">
                    @if(isset($item->XFPodCostTotal))
                        {{number_format($item->XFPodCostTotal,2)}}
                    @elseif(isset($item->XFGrdCostTotal))
                        {{number_format($item->XFGrdCostTotal,2)}}
                    @endif
                </td>

                <input type="hidden" name="xvmatcode[]" value="{{$item->xvmatcode}}">
                <input type="hidden" name="XVPodName[]"
                       @if(isset($item->XVPodName)) value="{{$item->XVPodName}}" @endif
                       @if(isset($item->XVGrdName)) value="{{$item->XVGrdName}}" @endif
                >
                <input type="hidden" class="form-control" name="XFPodCostTotal[]"
                       @if(isset($item->XFPodCostTotal)) value="{{number_format($item->XFPodCostTotal,2,'.','')}}" @endif
                       @if(isset($item->XFGrdCostTotal)) value="{{number_format($item->XFGrdCostTotal,2,'.','')}}" @endif
                       readonly/>
            </tr>
        @endforeach
        <tr style="height:15px;">
            <td scope="col" width="8%"></td>
            <td scope="col"></td>
            <td scope="col" width="10%"></td>
            <td scope="col" width="10%"></td>
            <td scope="col" width="10%"></td>
            <td scope="col" width="10%"></td>
            {{--            <td scope="col" width="10%"></td>--}}
            <td scope="col" width="3%"></td>
        </tr>
        <tr>
            <td colspan="4" class="text-right border-bottom-0 ">รวมจำนวนชิ้น</td>
            <td id="XIPohAmount"
                class="text-right "
                style="background-color: #e2e2e2">
                @if(isset($oldHD->XIPohAmount))
                    {{number_format($oldHD->XIPohAmount,2)}}
                @elseif(isset($oldHD->XIGrhAmount))
                    {{number_format($oldHD->XIGrhAmount,2)}}
                @endif
            </td>
            <input type="hidden" name="XIPohAmount" id="F_XIPohAmount"
                   @if(isset($oldHD->XIPohAmount)) value="{{$oldHD->XIPohAmount}}" @endif
                   @if(isset($oldHD->XIGrhAmount)) value="{{$oldHD->XIGrhAmount}}" @endif
            >
            <td colspan="1" class="text-right border-bottom-0">รวม</td>
            <td id="XFPohTotal"
                class="text-right "
                style="background-color: #e2e2e2">
                @if(isset($oldHD->XFPohTotal))
                    {{number_format($oldHD->XFPohTotal,2)}}
                @elseif(isset($oldHD->XFGrhTotal))
                    {{number_format($oldHD->XFGrhTotal,2)}}
                @endif
            </td>
            <input type="hidden" name="XFPohTotal" id="F_XFPohTotal"
                   @if(isset($oldHD->XFPohTotal)) value="{{$oldHD->XFPohTotal}}" @endif
                   @if(isset($oldHD->XFGrhTotal)) value="{{$oldHD->XFGrhTotal}}" @endif
            >
        </tr>
        <tr style="display: none;">
            <td colspan="7" class="text-right border-bottom-0 border-top-0">ส่วนลดบิล</td>
            <td class=" border-top-0">
                <div class="input-group">
                    <input type="text" class="form-control text-right border-0 pr-0" id="XFBillDiscount"
                           name="XFBillDiscount"
                           value="{{$oldHD->XFBillDiscount ?? 0}}"
                           onchange="BillDiscount()"
                           onkeypress='return isNumberKey(event)'
                           min="0">
                </div>
            </td>
        </tr>
        <tr style="display: none;">
            <td colspan="7" class="text-right border-bottom-0 border-top-0">หลังลด</td>
            <td id="XFPohAfterBillDC"
                style="background-color: #e2e2e2"
                class="text-right  border-top-0">
                @if(isset($oldHD->XFPohAfterBillDC))
                    {{number_format($oldHD->XFPohAfterBillDC,2)}}
                @elseif(isset($oldHD->XFGrhAfterBillDC))
                    {{number_format($oldHD->XFGrhAfterBillDC,2)}}
                @endif
            </td>
            <input type="hidden" name="XFPohAfterBillDC" id="F_XFPohAfterBillDC"
                   @if(isset($oldHD->XFPohAfterBillDC)) value="{{$oldHD->XFPohAfterBillDC}}" @endif
                   @if(isset($oldHD->XFGrhAfterBillDC)) value="{{$oldHD->XFGrhAfterBillDC}}" @endif
            >
        </tr>
        <tr>
            <td colspan="6" class="text-right border-bottom-0 border-top-0">ยอดรวมก่อนภาษี</td>
            <td id="XFPohBeforeVat"
                style="background-color: #e2e2e2"
                class="text-right  border-top-0">
                @if(isset($oldHD->XFPohBeforeVat))
                    {{number_format($oldHD->XFPohBeforeVat,2)}}
                @elseif(isset($oldHD->XFGrhBeforeVat))
                    {{number_format($oldHD->XFGrhBeforeVat,2)}}
                @endif
            </td>
            <input type="hidden" name="XFPohBeforeVat" id="F_XFPohBeforeVat"
                   @if(isset($oldHD->XFPohBeforeVat)) value="{{$oldHD->XFPohBeforeVat}}" @endif
                   @if(isset($oldHD->XFGrhBeforeVat)) value="{{$oldHD->XFGrhBeforeVat}}" @endif
            >
        </tr>
        <tr>
            <td colspan="4" class="text-right border-bottom-0 border-top-0 border-right-0">ภาษีมูลค่าเพิ่ม ( VAT )</td>
            <td class="border-0">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <div class="input-group-text">
                            <input type="checkbox"
                                   id="XBPohIsTax"
                                   onclick="return false;"
                                   name="XBPohIsTax"
                                   @if(isset($oldHD->XBPohIsTax) && $oldHD->XBPohIsTax==1)
                                   checked
                                   @endif
                                   @if(isset($oldHD->XBGrhIsTax) && $oldHD->XBGrhIsTax==1)
                                   checked
                                   @endif
                                   onchange="includeTax();">
                        </div>
                    </div>
                    <input type="text" class="form-control text-right" id="XIPohTax"
                           name="XIPohTax"
                           readonly
                           @if(isset($oldHD->XIPohTax)) value="{{$oldHD->XIPohTax}}" @endif
                           @if(isset($oldHD->XIGrhTax)) value="{{$oldHD->XIGrhTax}}" @endif
                           onchange="includeTax();"
                           min="0">
                    <div class="input-group-append">
                        <span class="input-group-text">%</span>
                    </div>
                </div>
            </td>
            <td colspan="1" class="text-right border-bottom-0 border-top-0 border-left-0">มูลค่า Vat</td>
            <td id="XFPohTotalVat"
                style="background-color: #e2e2e2"
                class="text-right  border-top-0">
                @if(isset($oldHD->XFPohTotalVat))
                    {{number_format($oldHD->XFPohTotalVat,2)}}
                @elseif(isset($oldHD->XFGrhTotalVat))
                    {{number_format($oldHD->XFGrhTotalVat,2)}}
                @endif
            </td>
            <input type="hidden" name="XFPohTotalVat" id="F_XFPohTotalVat"
                   @if(isset($oldHD->XFPohTotalVat)) value="{{$oldHD->XFPohTotalVat}}" @endif
                   @if(isset($oldHD->XFGrhTotalVat)) value="{{$oldHD->XFGrhTotalVat}}" @endif
            >

        </tr>
        <tr>
            <td colspan="6" class="text-right border-bottom-0 border-top-0">รวมทั้งสิ้น</td>
            <td id="XFPohNet"
                style="background-color: #e2e2e2"
                class="text-right  border-top-0">
                @if(isset($oldHD->XFPohNet))
                    {{number_format($oldHD->XFPohNet,2)}}
                @elseif(isset($oldHD->XFGrhNet))
                    {{number_format($oldHD->XFGrhNet,2)}}
                @endif
            </td>
            <input type="hidden" name="XFPohNet" id="F_XFPohNet"
                   @if(isset($oldHD->XFPohNet)) value="{{$oldHD->XFPohNet}}" @endif
                   @if(isset($oldHD->XFGrhNet)) value="{{$oldHD->XFGrhNet}}" @endif
            >
        </tr>
        </tbody>
    </table>
</div>
