@extends('layouts.master')
@section('header')
    <link href="{{ asset('css/gijgo.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('css/select2.min.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('css/select2-bootstrap4.min.css') }}">

@endsection
@php
use Illuminate\Support\Facades\DB;
$MasterItems = DB::table('tmstmproduct');
if (isset($WhereType) && isset($ValueWhere) && isset($operator)) {
    $MasterItems->where($WhereType, $operator, $ValueWhere);
}
if (isset($FullJoin) && $FullJoin == true) {
    $MasterItems = $MasterItems
        ->join('tmseason', 'tmstmproduct.XISeasonCode', '.tmseason.XISeasonCode')
        ->join('tmforuse', 'tmstmproduct.XIForCode', '.tmforuse.XIForCode')
        ->join('tmgenerate', 'tmstmproduct.XIGenerateCode', '.tmgenerate.XIGenerateCode')
        ->join('tmshape', 'tmstmproduct.XIShapeCode', '.tmshape.XIShapeCode')
        ->join('tmstmmaterial', 'tmstmproduct.xvmatcode', '.tmstmmaterial.xvmatcode');
}
$MasterItems = $MasterItems
    ->orderBy('xvpdtcode', 'asc')
    ->get()
    ->toArray();
foreach ($MasterItems as $item) {
    $item->size = DB::table('tmstmproductsize')
        ->where('xvpdtcode', '=', $item->xvpdtcode)
        ->get()
        ->toArray();
}
@endphp
@section('content')

<meta name="csrf-token" content="{{ csrf_token() }}" />
    <div class="card">
        <div class="card-body">
            <div class="row ">
                <div class="col-6">
                    <h5 style="font-weight: bold;">รายงานสินค้าคงคลัง</h5>
                </div>
                <div class="col-6 text-right">
                    <a href="{{route('report.dashboard.index')}}" class="btn btn-danger ">ย้อนกลับ</a>
                </div>
            </div>
            <hr>
            <div class="card-body">
                <div class="row mt-1 ">
                    <div class="card " style="max-width: 650px;min-width: 650px;margin: auto;
                        padding: 10px;">
                        <div class="col-12 text-center mt-2">
                            <h6 style="font-weight: bold ">เงื่อนไขในการเลือก</h6>
                        </div>
                        <div class="card-body">
                            <div class="row mt-4">
                                <div class="col-12">
                                    <h6 style="font-weight: bold">สินค้า</h6>
                                    <input type="checkbox" class="mr-2" id="AllCst" onclick="AllCst()" checked>ทั้งหมด
                                    <div class="row mt-2">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3  pr-2 text-right">จาก</p>
                                        <select class="form-control"  style="max-width: 480px;min-width: 480px;" id="SelectMasterItemsStart" name="SelectMasterItemsStart" @if (isset($isMultiple) && $isMultiple == true) multiple @endif @if (isset($isRequired) && $isRequired == true) required @endif
                                    @if (isset($isReadOnly) && $isReadOnly == true)
                                        readonly @endif
                                    >
                                    <option></option>
                                    @foreach ($MasterItems as $key => $item)
                                        <option value="{{ $item->xvpdtcode }}" @if (isset($oldValue) && $oldValue != null && $oldValue == $item->xvpdtcode) selected @endif
                                            data-Size="{{ json_encode($item->size) }}"
                                            data-item="{{ json_encode($item) }}">
                                            {{ $item->xvpdtcode }} : {{ $item->xvpdtname }}</option>
                                    @endforeach
                                </select>
                                    </div>
                                    <div class="row mt-2">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3  pr-2 text-right">ถึง</p>

                                        <select class="form-control "  style="max-width: 480px;min-width: 480px;"  id="SelectMasterItemsEnd" name="SelectMasterItemsEnd" @if (isset($isMultiple) && $isMultiple == true) multiple @endif @if (isset($isRequired) && $isRequired == true) required @endif
                                        @if (isset($isReadOnly) && $isReadOnly == true)
                                            readonly @endif
                                        >
                                        <option></option>
                                        @foreach ($MasterItems as $key => $item)
                                            <option value="{{ $item->xvpdtcode }}" @if (isset($oldValue) && $oldValue != null && $oldValue == $item->xvpdtcode) selected @endif
                                                data-Size="{{ json_encode($item->size) }}"
                                                data-item="{{ json_encode($item) }}">
                                                {{ $item->xvpdtcode }} : {{ $item->xvpdtname }}</option>
                                        @endforeach
                                    </select>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="row mt-1">

                            <div class="col-8 text-right">
                                <button class="btn btn-info bottom " style="vertical-align: bottom;" onclick="datareport()">
                                    export pdf</button>
                                <button class="btn btn-success bottom " style="vertical-align: bottom;" onclick=" datareportexcel()">export
                                    excel</button>
                            </div>
                        </div>
                    </div>
                    <div id="a" style=" visibility: hidden;" > 
                    
                        <table id="example" >
                        </table>
                </div>
                </div>
            </div>
        </div>
    </div>
    </div>
    <input type="hidden" id="CstEnd" >
    <input type="hidden" id="CstStart" >
     <script src="//unpkg.com/xlsx/dist/xlsx.full.min.js" type="text/javascript"></script>
    <script>
        $(document).ready(function() {

            AllCst();
            const MstStart = $('#SelectMasterItemsStart').select2({
                placeholder: "เลือกสินค้า",
                theme: 'bootstrap4',
            });
            const MstEnd =$('#SelectMasterItemsEnd').select2({
                placeholder: "เลือกสินค้า",
                theme: 'bootstrap4',
            });
            Date.prototype.toDateInputValue = (function() {
                var local = new Date(this);
                local.setMinutes(this.getMinutes() - this.getTimezoneOffset());
                return local.toJSON().slice(0, 10);
            });

            MstEnd.on('select2:select', function (e) {
                var {id, text} = (e.params.data);
                $("#CstEnd").val(text.trim());
            });
            MstStart.on('select2:select', function (e) {
                var {id, text} = (e.params.data);
                $("#CstStart").val(text.trim());
            });


        })


    </script>

    <script>
         function excel() 
        {
            var wb = XLSX.utils.table_to_book(document.getElementById('example'));
      XLSX.writeFile(wb, 'รายงาน 406 รายงานสินค้าคงคลัง' + convertDateToLocale(new Date().toDateInputValue()) + '.xlsx');
      return false;
        }
        function AllCst() {
            var checkBox = document.getElementById("AllCst");
            if (checkBox.checked == true) {
                document.getElementById('SelectMasterItemsStart').disabled = true;
                document.getElementById('SelectMasterItemsEnd').disabled = true;
            } else {
                document.getElementById('SelectMasterItemsStart').disabled = false;
                document.getElementById('SelectMasterItemsEnd').disabled = false;
            }
        }

        function datareport() {
            const MstStart = document.getElementById('SelectMasterItemsStart').value;
            const MstEnd = document.getElementById('SelectMasterItemsEnd').value;
            const isAllMst =document.getElementById("AllCst").checked;

            const MstStartToppic = document.getElementById('CstStart').value;
            const MstEndToppic = document.getElementById('CstEnd').value;
            let _token = $('meta[name="csrf-token"]').attr('content');
            let JsonFilter = {
                MstStartToppic : MstStart,
                MstEndToppic : MstEnd,
                isAllMst,
            };
            $.ajax({
                url: '{{ route('report.406.data') }}',
                type: "POST",
                data: {
                    _token: _token,
                    MstStart,
                    MstEnd,
                    isAllMst,
                },
                success: function (result) {
                    console.log(result);
                 renderPdf(result, JsonFilter);
                }
            });
        }
        function datareportexcel() 
        {
           
            var dataSet = [];
            const MstStart = document.getElementById('SelectMasterItemsStart').value;
            const MstEnd = document.getElementById('SelectMasterItemsEnd').value;
            const isAllMst =document.getElementById("AllCst").checked;

            const MstStartToppic = document.getElementById('CstStart').value;
            const MstEndToppic = document.getElementById('CstEnd').value;
            let _token = $('meta[name="csrf-token"]').attr('content');
            $.ajax({
                url: '{{ route('report.406.dataexcel') }}',
                type: "POST",
                data: {
                    _token: _token,
                    MstStart,
                    MstEnd,
                    isAllMst
                },
                success: function(result) {
                    console.log(result);
                    var dataSet = [];
                    var tempQty=0;
                    for (let index = 0; index < result.length; index++) {  
                        var row=[result[index].xvpdtcode,
                                result[index].xvpdtname,
                                result[index].qty,
                            ];
                            dataSet.push(row);
                    }
                    console.log(dataSet);    
                    var i = 0;
                    $('table tbody').remove()
                    $('#example').DataTable({
                        "destroy": true,
                        "data": dataSet,
                        paging: false,
                        "columns": [

                            {
                                "title": "รหัสสินค้า",
                            },
                            {   "title": "ชื่อสินค้า",
                            },
                            {   "title": "จำนวนคงเหลือ",
                            },
                            


                        ]
                    });
                    if(isAllMst)
                    {
                        
                        matstart = "ทั้งหมด";
                         matend= "ทั้งหมด";
                    }
                    else
                    {
                        matstart = MstStartToppic;
                        matend= MstEndToppic;
                    }

                    var htmltb = document.getElementById('example').innerHTML;
                    console.log(htmltb)
                    console.log(document.getElementsByTagName('thead')[0].innerHTML)
                    console.log(document.getElementsByTagName('tbody')[0].innerHTML)
                    document.getElementById('example').innerHTML =
                    "<thead>"+
                    "<tr><th  colspan='8' class='text-center' >406 รายงานสินค้าคงคลัง</th></tr>"+
                    "<tr><th  colspan='8' class='text-center'> วันที่ "+ convertDateToLocale(new Date().toDateInputValue())+"</th></tr> "+
                    "<tr><th  colspan='8' class='text-center'>จากสินค้า "+matstart+" ถึง "+matend+"</th></tr>"+
                    document.getElementsByTagName('thead')[0].innerHTML+
                    "</thead>"+
                    document.getElementsByTagName('tbody')[0].innerHTML
                    ;
                    excel();
                    $('table tbody').remove()
                    document.getElementById('a').innerHTML =" <table id='example' ></table>"
                  

                   
                   
                   
                }
            });
        }
        function convertDateToLocale(date) {
    return new Date(date).toLocaleDateString('th')
}
    </script>
@endsection
<script src="{{ asset('js/pages/report/R406.js') }}"></script>
<script src="{{ asset('js/jquery-3.5.1.min.js') }}"></script>
<script src="{{ asset('js/gijgo.min.js') }}" defer type="text/javascript"></script>
<script src="{{ asset('js/select2.min.js') }}" defer></script>
<script src="{{ asset('js/sweetalert.min.js') }}"></script>
<script src="{{ asset('js/pdfmake.js') }}"></script>
