@extends('layouts.master')
@section('content')
@php
    $menuperm = Illuminate\Support\Facades\Session::get('menu_perm') ?? [];
@endphp
    <div class="card" style="width:99.99%;">
        <div class="card-body">
            <div class="row">
                <div class="col">
                    <h5 style="font-weight: bold;">ใบปรับคลังวัสดุ</h5>
                </div>
                @if (in_array(11,$menuperm))
                <div class="col-6 text-right">
                    <a href="{{route('adj.add')}}" class="btn btn-success"><i class="fas fa-plus-square"></i> เพิ่มข้อมูล</a>
                </div>
                @endif
{{--                <div class="col-1 text-left">--}}
{{--                    <a type="submit" class="btn btn-primary" data-toggle="modal" data-target="#exampleModalCenter">Filter--}}
{{--                        วัสดุ</a>--}}
{{--                </div>--}}

            </div>
            <hr>
            <div class="row mt-5 d-flex justify-content-center">
                <div class="col-12 table-responsive ">
                    <table id="tb_mat" class="table table-striped mt-5">
                        <thead class="thead-light">
                        <tr>
                            <td class="text-left">ลำดับ</td>
                            <td class="text-center">เลขที่ AJ</td>
                            <td class="text-center">วันที่</td>
                            <td class="text-left" style="width:'300px'">ผู้ตรวจสอบ</td>
{{--                            <td class="text-center" width="10%">หมายเหตุ</td>--}}
                            <td class="text-left">สถานะเอกสาร</td>
                            <td class="text-center">แก้ไข</td>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($HD as $key => $item)
                            <tr>
                                <td class="text-left">{{$key += 1}}</td>
                                <td class="text-center">{{$item->XVAjhDocNo}}</td>
                                <td class="text-center">{{date_YmdTodmY($item->XDAjhDocDate)}}</td>
                                <td class="text-left" style="width:'300px'">{{$item->name}}</td>
{{--                                <td class="text-center">{{$item->XVAjhDocRmk}}</td>--}}
                                <td class="text-left">{{getDocStatusByCode($item->XVAjhDocStatus)}}</td>
                                <td class="text-center">
                                    <a href="{{route('adj.edit',$item->XVAjhDocNo)}}" class="btn-sm btn-info"><i
                                            class="fas fa-edit fa-1x"></i></a>
                                </td>

                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <input type="hidden" name="msg" value="{{session()->get('msg')}}">
    <input type="hidden" id="url" value="{{url('')}}">
@endsection
<style>
    #tb_mat thead {
        font-weight: bold;
    }

    #tb_mat tbody {
        font-size: 14px;
    }

    #tb_mat tbody tr:hover {
        background-color: azure;
    }

    #tb_mat tbody td {
        height: 35px;
        vertical-align: middle;
        cursor: pointer;
    }

    #tb_mat_filter {
        margin-bottom: 1cm;
        margin-top: 0.3cm;
    }
</style>
<script src="{{asset('js/ThbNumber.js')}}"></script>
<script src="{{asset('js/jquery-3.5.1.min.js')}}"></script>
<script src="{{asset('js/sweetalert.min.js')}}"></script>
<script src="{{ asset('js/pdfmake.js') }}"></script>
{{--<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"--}}
{{--        defer></script>--}}
{{--<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js" defer></script>--}}
{{--<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js" defer></script>--}}
{{--<script src="{{ asset('js/buttons.html5.min.js') }}" defer></script>--}}
{{--<script src="{{ asset('js/jszip.min.js') }}" defer></script>--}}
{{--<script src="{{ asset('js/dataTables.buttons.min.js') }}" defer></script>--}}
<script>
    $(document).ready(function () {

        $('#tb_mat').DataTable({
            "order": [],
            "language": {
                "search": "ค้นหา"
            },
        });

        if ($('input[name="msg"]').val() == 'success') {
            swal("บันทึกข้อมูลเรียบร้อย", "คลิก ตกลง", "success");
        }

    })
</script>
