@extends('layouts.master')
@php
$menuperm = Illuminate\Support\Facades\Session::get('menu_perm') ?? [];
@endphp

@section('header')
    <link href="{{ asset('css/gijgo.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('css/select2.min.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('css/select2-bootstrap4.min.css') }}">
@endsection
<style>
    div.sticky {
        position: sticky;
        top: 0;
        background-color: #ffffff;
        padding-top: 8px;
        z-index: 100;
    }

    form.noStyle {
        margin: 0;
    }

    .btn-circle.btn-sm {
        width: 30px;
        height: 30px;
        padding: 6px 0px;
        border-radius: 15px;
        font-size: 8px;
        text-align: center;
    }

    .form-control {
        display: inline-block !important;
    }

    tr:hover {
        background-color: #f5f5f5;
    }

</style>
@section('content')
    <form action="{{ route('order.updateStatus') }}" method="POST" style="margin: 0"
        onkeypress="return event.keyCode != 13;" id="updateForm"
        onsubmit="event.preventDefault(); return Swal_Ask('{{ getDocStatusByCode(3) }}',this)">
        @csrf
        <div class="col-1 text-left">
            <input type="hidden" class="form-control" name="XVOrhDocNo" value="{{ $hd->XVOrhDocNo }}" readonly>
            <input type="hidden" class="form-control" id="eventRequest" name="eventRequest" value="3" readonly>
            <input type="hidden" class="form-control" id="docStatus" name="docStatus" value="{{ $DocStatus }}" readonly>
        </div>
    </form>

    <form action="{{ route('order.update') }}" method="POST" id="Form_Submit" enctype="multipart/form-data" class="noStyle"
        onsubmit="return validateForm()">
        @csrf
        @method('PUT')
        <div class="card ">
            <div class="card-body">
                <div class="sticky">
                    <div class="row ">
                        <div class="col-3 ">
                            <h5>ฟอร์มแก้ไขข้อมูล Order</h5>
                        </div>

                        {{-- check Redirect --}}
                        @if (in_array(9, $menuperm))
                            @php
                                $routeBack = 'order.index';
                            @endphp

                        {{-- @else
                            @php
                                $routeBack = 'Approve.order';
                            @endphp --}}

                        @endif

                        @component('Components.HandleDocStatus', ['routeBack' => $routeBack, 'DocStatus' => $DocStatus])
                            <div class="col-1 text-left">
                                <a href="#" type="button" class="btn btn-info" onclick="renderPdf('{{ $hd->XVOrhDocNo }}')"><i
                                        class="far fa-file-pdf"></i> PDF</a>
                                <input type="hidden" id="url" value="{{ url('') }}">
                            </div>
                            <div class="col-1 text-left">
                                <a href="#" type="button" class="btn btn-warning"
                                    onclick="renderPdfBOM('{{ $hd->XVOrhDocNo }}')"><i class="far fa-file-pdf"></i> PDF BOM</a>
                                <input type="hidden" id="url" value="{{ url('') }}">
                            </div>
                        @endcomponent

                    </div>
                    <hr>
                </div>
                <h5>ข้อมูลเอกสาร</h5>
                @php
                    if (in_array(1, $menuperm)) {
                        $readoly = 'style=pointer-events:none;';
                    } else {
                        $readoly = '';
                    }
                @endphp
                <div class="row border " {{ $readoly }}>

                    <div class="col border-right ">

                        @component('order.components.hd', ['oldHD' => $hd, 'xvpdtcode' => $xvpdtcode])
                        @endcomponent
                    </div>
                    <div class="col border-right ">

                        @component('Components.Customer', ['oldValue' => $hd->XVCstCode])
                        @endcomponent
                    </div>

                </div>
                <div class="row border">
                    <div class="col border-right ">

                        @component('order.components.dt', ['oldDT' => $dt])
                        @endcomponent

                    </div>

                </div>
                <div class="row">
                    <div class="col border ">
                        @component('MasterItem.components.comment_detail', ['oldHD' => $hd])
                        @endcomponent
                    </div>
                    <div class="col border  ">

                        @component('MasterItem.components.comment_description', ['oldHD' => $hd])
                        @endcomponent
                        @component('Components.upload', ['oldPicture' => $imgUrl])
                        @endcomponent
                    </div>

                </div>
            </div>
        </div>
        </div>
    </form>
    <input type="hidden" value="{{ $xvpdtcode }}" id="oldSelectedPdtCode">
@endsection
<script src="{{ asset('js/helper.js') }}"></script>
<script src="{{ asset('js/jquery-3.5.1.min.js') }}"></script>
<script src="{{ asset('js/gijgo.min.js') }}" defer type="text/javascript"></script>
<script src="{{ asset('js/select2.min.js') }}" defer></script>
<script src="{{ asset('js/sweetalert.min.js') }}"></script>
<script src="{{ asset('js/pages/order/form.js') }}"></script>
<script src="{{ asset('js/ThbNumber.js') }}"></script>
<script src="{{ asset('js/pdfmake.js') }}"></script>
<script src="{{ asset('js/pages/Order/pdf.js') }}"></script>
<script>
    // SelectMasterItems
</script>

<script>
    async function Swal_Ask(text, form) {
        let resp = swal({
            title: `ยืนยันการ ${text} ?`,
            text: "หากยืนยันแล้วไม่สามารถเปลี่ยนแปลงได้",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
        let isOk = await resp
        if (isOk) form.submit();
    }

    async function updateStatus(statusCode, text) {
        const ApproveForm = document.getElementById("updateForm");
        const eventRequest = document.getElementById("eventRequest");
        let resp = swal({
            title: `ยืนยันการ ${text} ?`,
            text: "หากยืนยันแล้วไม่สามารถเปลี่ยนแปลงได้",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
        let isOk = await resp
        if (isOk) {
            eventRequest.value = statusCode
            ApproveForm.submit()
        };
    }

    $(document).ready(function() {
        updateTotalSumQty();
        const OldItem = document.getElementById('oldSelectedPdtCode').value;
        TriggerChange(OldItem);
        let dataSize = $("#SelectMasterItems").find('option:selected').attr('data-Size');
        dataSize = JSON.parse(dataSize);
        let selectSize = document.getElementById('SelectedTempSize');
        for (let i = 0; i < dataSize.length; i++) {
            let opt = document.createElement('option');
            const size = dataSize[i].XVPszName;
            opt.value = size;
            opt.innerHTML = size;
            selectSize.appendChild(opt);
        }
        var oldList = document.getElementsByClassName("dtItems")
        let oldArr = [];
        for (let i = 0; i < oldList.length; i++) {
            oldArr.push(oldList[i].id)
        }
        updateIndex(oldArr.length)
        TriggerChangeSize(oldArr)
    })
</script>
